/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.TimePeriod;
import java.util.Calendar;
import java.util.Date;

public class FixedMillisecond
extends TimePeriod {
    protected Date time;

    public FixedMillisecond() {
        this(new Date());
    }

    public FixedMillisecond(long millisecond) {
        this(new Date(millisecond));
    }

    public FixedMillisecond(Date time) {
        this.time = time;
    }

    public Date getTime() {
        return this.time;
    }

    public TimePeriod previous() {
        FixedMillisecond result = null;
        long t = this.time.getTime();
        if (t != Long.MIN_VALUE) {
            result = new FixedMillisecond(t - 1L);
        }
        return result;
    }

    public TimePeriod next() {
        FixedMillisecond result = null;
        long t = this.time.getTime();
        if (t != Long.MAX_VALUE) {
            result = new FixedMillisecond(t + 1L);
        }
        return result;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof FixedMillisecond) {
            FixedMillisecond t1 = (FixedMillisecond)o1;
            long difference = this.time.getTime() - t1.time.getTime();
            result = difference > 0L ? 1 : (difference < 0L ? -1 : 0);
        } else {
            result = o1 instanceof TimePeriod ? 0 : 1;
        }
        return result;
    }

    public long getStart() {
        return this.time.getTime();
    }

    public long getStart(Calendar calendar) {
        return this.time.getTime();
    }

    public long getEnd() {
        return this.time.getTime();
    }

    public long getEnd(Calendar calendar) {
        return this.time.getTime();
    }

    public long getMiddle() {
        return this.time.getTime();
    }

    public long getMiddle(Calendar calendar) {
        return this.time.getTime();
    }
}

