/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.XYDataPair;
import com.jrefinery.data.XYDataset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;

public class DefaultXYDataset
extends AbstractSeriesDataset
implements XYDataset {
    protected List seriesNames;
    protected List allSeriesData;

    public DefaultXYDataset() {
        this.seriesNames = new ArrayList();
        this.allSeriesData = new ArrayList();
    }

    public DefaultXYDataset(Object[][][] data) {
        this(DefaultXYDataset.seriesNameListFromDataArray((Object[][])data), data);
    }

    public DefaultXYDataset(String[] seriesNames, Object[][][] data) {
        this(Arrays.asList(seriesNames), data);
    }

    public DefaultXYDataset(List seriesNames, Object[][][] data) {
        this.seriesNames = seriesNames;
        int seriesCount = data.length;
        this.allSeriesData = new ArrayList(seriesCount);
        int series = 0;
        while (series < seriesCount) {
            ArrayList<XYDataPair> oneSeriesData = new ArrayList<XYDataPair>();
            int maxItemCount = data[series].length;
            int itemIndex = 0;
            while (itemIndex < maxItemCount) {
                Object xObject = data[series][itemIndex][0];
                if (xObject != null) {
                    Number xNumber = null;
                    if (xObject instanceof Number) {
                        xNumber = (Number)xObject;
                    } else if (xObject instanceof Date) {
                        Date xDate = (Date)xObject;
                        xNumber = new Long(xDate.getTime());
                    } else {
                        xNumber = new Integer(0);
                    }
                    Number yNumber = (Number)data[series][itemIndex][1];
                    oneSeriesData.add(new XYDataPair(xNumber, yNumber));
                }
                ++itemIndex;
            }
            Collections.sort(oneSeriesData);
            this.allSeriesData.add(series, oneSeriesData);
            ++series;
        }
    }

    public int getSeriesCount() {
        return this.allSeriesData.size();
    }

    public int getItemCount(int series) {
        List oneSeriesData = (List)this.allSeriesData.get(series);
        return oneSeriesData.size();
    }

    public String getSeriesName(int series) {
        return this.seriesNames.get(series).toString();
    }

    public void setSeriesNames(String[] seriesNames) {
        this.seriesNames = Arrays.asList(seriesNames);
        this.fireDatasetChanged();
    }

    public Number getXValue(int series, int item) {
        List oneSeriesData = (List)this.allSeriesData.get(series);
        XYDataPair xy = (XYDataPair)oneSeriesData.get(item);
        return xy.x;
    }

    public Number getYValue(int series, int item) {
        List oneSeriesData = (List)this.allSeriesData.get(series);
        XYDataPair xy = (XYDataPair)oneSeriesData.get(item);
        return xy.y;
    }

    public static List seriesNameListFromDataArray(Object[][] data) {
        String baseName = "com.jrefinery.data.resources.DataPackageResources";
        ResourceBundle resources = ResourceBundle.getBundle(baseName);
        String prefix = resources.getString("series.default-prefix") + " ";
        int seriesCount = data.length;
        ArrayList<String> seriesNameList = new ArrayList<String>(seriesCount);
        int i = 0;
        while (i < seriesCount) {
            seriesNameList.add(prefix + (i + 1));
            ++i;
        }
        return seriesNameList;
    }
}

