/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.WindDataItem;
import com.jrefinery.data.WindDataset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DefaultWindDataset
extends AbstractSeriesDataset
implements WindDataset {
    protected List seriesNames;
    protected List allSeriesData;

    public DefaultWindDataset() {
        this.seriesNames = new ArrayList();
        this.allSeriesData = new ArrayList();
    }

    public DefaultWindDataset(Object[][][] data) {
        this(DefaultWindDataset.seriesNameListFromDataArray((Object[][])data), data);
    }

    public DefaultWindDataset(String[] seriesNames, Object[][][] data) {
        this(Arrays.asList(seriesNames), data);
    }

    public DefaultWindDataset(List seriesNames, Object[][][] data) {
        this.seriesNames = seriesNames;
        int seriesCount = data.length;
        this.allSeriesData = new ArrayList(seriesCount);
        int seriesIndex = 0;
        while (seriesIndex < seriesCount) {
            ArrayList<WindDataItem> oneSeriesData = new ArrayList<WindDataItem>();
            int maxItemCount = data[seriesIndex].length;
            int itemIndex = 0;
            while (itemIndex < maxItemCount) {
                Object xObject = data[seriesIndex][itemIndex][0];
                if (xObject != null) {
                    Number xNumber = null;
                    if (xObject instanceof Number) {
                        xNumber = (Number)xObject;
                    } else if (xObject instanceof Date) {
                        Date xDate = (Date)xObject;
                        xNumber = new Long(xDate.getTime());
                    } else {
                        xNumber = new Integer(0);
                    }
                    Number windDir = (Number)data[seriesIndex][itemIndex][1];
                    Number windForce = (Number)data[seriesIndex][itemIndex][2];
                    oneSeriesData.add(new WindDataItem(xNumber, windDir, windForce));
                }
                ++itemIndex;
            }
            Collections.sort(oneSeriesData);
            this.allSeriesData.add(seriesIndex, oneSeriesData);
            ++seriesIndex;
        }
    }

    public int getSeriesCount() {
        return this.allSeriesData.size();
    }

    public int getItemCount(int series) {
        List oneSeriesData = (List)this.allSeriesData.get(series);
        return oneSeriesData.size();
    }

    public String getSeriesName(int series) {
        return this.seriesNames.get(series).toString();
    }

    public Number getXValue(int series, int item) {
        List oneSeriesData = (List)this.allSeriesData.get(series);
        WindDataItem windItem = (WindDataItem)oneSeriesData.get(item);
        return windItem.x;
    }

    public Number getYValue(int series, int item) {
        return this.getWindForce(series, item);
    }

    public Number getWindDirection(int series, int item) {
        List oneSeriesData = (List)this.allSeriesData.get(series);
        WindDataItem windItem = (WindDataItem)oneSeriesData.get(item);
        return windItem.windDir;
    }

    public Number getWindForce(int series, int item) {
        List oneSeriesData = (List)this.allSeriesData.get(series);
        WindDataItem windItem = (WindDataItem)oneSeriesData.get(item);
        return windItem.windForce;
    }

    public static List seriesNameListFromDataArray(Object[][] data) {
        int seriesCount = data.length;
        ArrayList<String> seriesNameList = new ArrayList<String>(seriesCount);
        int i = 0;
        while (i < seriesCount) {
            seriesNameList.add("Series " + (i + 1));
            ++i;
        }
        return seriesNameList;
    }
}

