/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractDataset;
import com.jrefinery.data.MeterDataset;

public class DefaultMeterDataset
extends AbstractDataset
implements MeterDataset {
    static final double DEFAULT_ADJ = 1.0;
    Number minCritical;
    Number maxCritical;
    Number minWarning;
    Number maxWarning;
    Number minNormal;
    Number maxNormal;
    Number min;
    Number max;
    Number value;
    int borderType;
    String units;

    public DefaultMeterDataset() {
        this(new Double(0.0), new Double(0.0), null, null);
    }

    public DefaultMeterDataset(Number min, Number max, Number value, String units) {
        this(min, max, value, units, null, null, null, null, null, null, 0);
    }

    public DefaultMeterDataset(Number min, Number max, Number value, String units, Number minCritical, Number maxCritical, Number minWarning, Number maxWarning, Number minNormal, Number maxNormal, int borderType) {
        this.setRange(min, max);
        this.setValue(value);
        this.setUnits(units);
        this.setCriticalRange(minCritical, maxCritical);
        this.setWarningRange(minWarning, maxWarning);
        this.setNormalRange(minNormal, maxNormal);
        this.setBorderType(borderType);
    }

    public Number getMinimumCriticalValue() {
        return this.minCritical;
    }

    public Number getMaximumCriticalValue() {
        return this.maxCritical;
    }

    public Number getMinimumWarningValue() {
        return this.minWarning;
    }

    public Number getMaximumWarningValue() {
        return this.maxWarning;
    }

    public Number getMinimumNormalValue() {
        return this.minNormal;
    }

    public Number getMaximumNormalValue() {
        return this.maxNormal;
    }

    public Number getMinimumValue() {
        return this.min;
    }

    public Number getMaximumValue() {
        return this.max;
    }

    public Number getValue() {
        return this.value;
    }

    public String getUnits() {
        return this.units;
    }

    public boolean isValueValid() {
        return this.value != null;
    }

    public int getBorderType() {
        return this.borderType;
    }

    public void setUnits(String units) {
        this.units = units;
        this.fireDatasetChanged();
    }

    public void setBorderType(int borderType) {
        this.borderType = borderType;
        this.fireDatasetChanged();
    }

    public void setValue(Number value) {
        if (value != null && this.min != null && this.max != null && (value.doubleValue() < this.min.doubleValue() || value.doubleValue() > this.max.doubleValue())) {
            throw new IllegalArgumentException("Value is out of range for min/max");
        }
        this.value = value;
        if (value != null && this.min != null && this.max != null && this.min.doubleValue() == this.max.doubleValue()) {
            this.min = new Double(value.doubleValue() - 1.0);
            this.max = new Double(value.doubleValue() + 1.0);
        }
        this.fireDatasetChanged();
    }

    public void setRange(Number min, Number max) {
        if (min == null || max == null) {
            throw new IllegalArgumentException("Min/Max should not be null");
        }
        if (min.doubleValue() > max.doubleValue()) {
            Number temp = min;
            min = max;
            max = temp;
        }
        if (this.value != null && min.doubleValue() == max.doubleValue()) {
            min = new Double(this.value.doubleValue() - 1.0);
            max = new Double(this.value.doubleValue() + 1.0);
        }
        this.min = min;
        this.max = max;
        this.fireDatasetChanged();
    }

    public void setNormalRange(Number minNormal, Number maxNormal) {
        this.minNormal = minNormal;
        this.maxNormal = maxNormal;
        if (this.minNormal != null && this.minNormal.doubleValue() < this.min.doubleValue()) {
            this.min = this.minNormal;
        }
        if (this.maxNormal != null && this.maxNormal.doubleValue() > this.max.doubleValue()) {
            this.max = this.maxNormal;
        }
        this.fireDatasetChanged();
    }

    public void setWarningRange(Number minWarning, Number maxWarning) {
        this.minWarning = minWarning;
        this.maxWarning = maxWarning;
        if (this.minWarning != null && this.minWarning.doubleValue() < this.min.doubleValue()) {
            this.min = this.minWarning;
        }
        if (this.maxWarning != null && this.maxWarning.doubleValue() > this.max.doubleValue()) {
            this.max = this.maxWarning;
        }
        this.fireDatasetChanged();
    }

    public void setCriticalRange(Number minCritical, Number maxCritical) {
        this.minCritical = minCritical;
        this.maxCritical = maxCritical;
        if (this.minCritical != null && this.minCritical.doubleValue() < this.min.doubleValue()) {
            this.min = this.minCritical;
        }
        if (this.maxCritical != null && this.maxCritical.doubleValue() > this.max.doubleValue()) {
            this.max = this.maxCritical;
        }
        this.fireDatasetChanged();
    }

    static {
        DEFAULT_ADJ = 1.0;
    }
}

