/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.DatasetUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;

public class DefaultCategoryDataset
extends AbstractSeriesDataset
implements CategoryDataset {
    protected String[] seriesNames;
    protected Object[] categories;
    protected Number[][] data;

    public DefaultCategoryDataset(double[][] data) {
        this(DatasetUtilities.createNumberArray2D(data));
    }

    public DefaultCategoryDataset(Number[][] data) {
        this(null, null, data);
    }

    public DefaultCategoryDataset(String[] seriesNames, Number[][] data) {
        this(seriesNames, null, data);
    }

    public DefaultCategoryDataset(String[] seriesNames, Object[] categories, Number[][] data) {
        this.data = data;
        if (data != null) {
            String baseName = "com.jrefinery.data.resources.DataPackageResources";
            ResourceBundle resources = ResourceBundle.getBundle(baseName);
            int series_count = data.length;
            if (series_count > 0) {
                if (seriesNames != null) {
                    if (seriesNames.length != series_count) {
                        throw new IllegalArgumentException("DefaultCategoryDataset: the number of series names does not match the number of series in the data.");
                    }
                    this.seriesNames = seriesNames;
                } else {
                    String prefix = resources.getString("series.default-prefix") + " ";
                    this.seriesNames = this.generateNames(series_count, prefix);
                }
                int category_count = data[0].length;
                if (categories != null) {
                    if (categories.length != category_count) {
                        throw new IllegalArgumentException("DefaultCategoryDataset: the number of categories does not match the number of categories in the data.");
                    }
                    this.categories = categories;
                } else {
                    String prefix = resources.getString("categories.default-prefix") + " ";
                    this.categories = this.generateNames(category_count, prefix);
                }
            } else {
                this.seriesNames = null;
                this.categories = null;
            }
        }
    }

    public int getSeriesCount() {
        int result = 0;
        if (this.data != null) {
            result = this.data.length;
        }
        return result;
    }

    public String getSeriesName(int series) {
        if (series >= this.getSeriesCount() || series < 0) {
            throw new IllegalArgumentException("DefaultCategoryDataset.getSeriesName(int): no such series.");
        }
        return this.seriesNames[series];
    }

    public void setSeriesName(int series, String name) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setSeriesName(...): no such series.");
        }
        if (name == null) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setSeriesName(...): null not permitted.");
        }
        this.seriesNames[series] = name;
        this.fireDatasetChanged();
    }

    public void setSeriesNames(String[] seriesNames) {
        if (seriesNames == null) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setSeriesNames(): null not permitted.");
        }
        if (seriesNames.length != this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setSeriesNames(): the number of series names does not match the data.");
        }
        this.seriesNames = seriesNames;
        this.fireDatasetChanged();
    }

    public int getCategoryCount() {
        int result = 0;
        if (this.data != null && this.getSeriesCount() > 0) {
            result = this.data[0].length;
        }
        return result;
    }

    public List getCategories() {
        if (this.categories == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.categories));
    }

    public void setCategories(Object[] categories) {
        if (categories == null) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setCategories(...): null not permitted.");
        }
        if (categories.length != this.data[0].length) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setCategories(...): the number of categories does not match the data.");
        }
        int i = 0;
        while (i < categories.length) {
            if (categories[i] == null) {
                throw new IllegalArgumentException("DefaultCategoryDataset.setCategories(...): null category not permitted.");
            }
            ++i;
        }
        this.categories = categories;
        this.fireDatasetChanged();
    }

    public Number getValue(int series, Object category) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultCategoryDataset.getValue(...): series index out of range.");
        }
        if (category == null) {
            throw new IllegalArgumentException("DefaultCategoryDataset.getValue(...): null category not allowed.");
        }
        int categoryIndex = this.getCategoryIndex(category);
        if (categoryIndex < 0) {
            throw new IllegalArgumentException("DefaultCategoryDataset.getValue(...): unknown category.");
        }
        return this.data[series][categoryIndex];
    }

    public void setValue(int series, Object category, Number value) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setValue: series outside valid range.");
        }
        int categoryIndex = this.getCategoryIndex(category);
        if (categoryIndex < 0) {
            throw new IllegalArgumentException("DefaultCategoryDataset.setValue: unrecognised category.");
        }
        this.data[series][categoryIndex] = value;
        this.fireDatasetChanged();
    }

    private int getCategoryIndex(Object category) {
        int result = -1;
        int i = 0;
        while (i < this.categories.length) {
            if (category.equals(this.categories[i])) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    private String[] generateNames(int count, String prefix) {
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            String name;
            result[i] = name = prefix + (i + 1);
            ++i;
        }
        return result;
    }
}

