/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.tooltips;

import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.TimeSeriesCollection;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.XisSymbolic;
import com.jrefinery.data.YisSymbolic;

public class SymbolicXYToolTipGenerator
implements XYToolTipGenerator {
    public String generateToolTip(XYDataset data, int series, int item) {
        String x;
        Number n;
        String y;
        if (data instanceof YisSymbolic) {
            y = ((YisSymbolic)((Object)data)).getYSymbolicValue(series, item);
        } else {
            n = data.getYValue(series, item);
            y = Double.toString(SymbolicXYToolTipGenerator.round(n.doubleValue(), 2));
        }
        if (data instanceof XisSymbolic) {
            x = ((XisSymbolic)((Object)data)).getXSymbolicValue(series, item);
        } else if (data instanceof TimeSeriesCollection) {
            TimePeriod p = ((TimeSeriesCollection)data).getSeries(series).getTimePeriod(item);
            x = p.toString();
        } else {
            n = data.getXValue(series, item);
            x = Double.toString(SymbolicXYToolTipGenerator.round(n.doubleValue(), 2));
        }
        return "X: " + x + ", Y: " + y;
    }

    private static double round(double value, int nb) {
        if (nb <= 0) {
            return Math.floor(value + 0.5);
        }
        double p = Math.pow(10.0, nb);
        double tempval = Math.floor(value * p + 0.5);
        return tempval / p;
    }
}

