/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.tooltips;

import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.XYDataset;
import java.text.DateFormat;
import java.util.Date;

public class HighLowToolTipGenerator
implements XYToolTipGenerator {
    protected DateFormat dateFormatter = DateFormat.getInstance();

    public String generateToolTip(XYDataset data, int series, int item) {
        String result = null;
        if (data instanceof HighLowDataset) {
            HighLowDataset d = (HighLowDataset)data;
            Number high = d.getHighValue(series, item);
            Number low = d.getLowValue(series, item);
            Number open = d.getOpenValue(series, item);
            Number close = d.getCloseValue(series, item);
            Number x = d.getXValue(series, item);
            result = d.getSeriesName(series);
            if (x != null) {
                Date date = new Date(x.longValue());
                result = result + "--> Date=" + this.dateFormatter.format(date);
            }
            if (high != null) {
                result = result + " High=" + high.toString();
            }
            if (low != null) {
                result = result + " Low=" + low.toString();
            }
            if (open != null) {
                result = result + " Open=" + open.toString();
            }
            if (close != null) {
                result = result + " Close=" + close.toString();
            }
        }
        return result;
    }
}

