/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.junit;

import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.ChartChangeEvent;
import com.jrefinery.chart.event.ChartChangeListener;
import com.jrefinery.data.Range;
import com.jrefinery.data.XYSeries;
import com.jrefinery.data.XYSeriesCollection;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ScatterPlotTests
extends TestCase {
    private JFreeChart chart;
    static /* synthetic */ Class class$com$jrefinery$chart$junit$ScatterPlotTests;

    public static Test suite() {
        return new TestSuite(class$com$jrefinery$chart$junit$ScatterPlotTests == null ? (class$com$jrefinery$chart$junit$ScatterPlotTests = ScatterPlotTests.class$("com.jrefinery.chart.junit.ScatterPlotTests")) : class$com$jrefinery$chart$junit$ScatterPlotTests);
    }

    public ScatterPlotTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.chart = ScatterPlotTests.createChart();
    }

    public void testDrawWithNullInfo() {
        boolean success = false;
        try {
            BufferedImage image = new BufferedImage(200, 100, 1);
            Graphics2D g2 = image.createGraphics();
            this.chart.draw(g2, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null);
            g2.dispose();
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        ScatterPlotTests.assertTrue((boolean)success);
    }

    public void testReplaceDataset() {
        XYSeries series1 = new XYSeries("Series 1");
        series1.add(10.0, 10.0);
        series1.add(20.0, 20.0);
        series1.add(30.0, 30.0);
        XYSeriesCollection dataset = new XYSeriesCollection(series1);
        LocalListener l = new LocalListener();
        this.chart.addChangeListener(l);
        this.chart.getPlot().setDataset(dataset);
        ScatterPlotTests.assertEquals((boolean)true, (boolean)l.flag);
        ValueAxis axis = this.chart.getXYPlot().getRangeAxis();
        Range range = axis.getRange();
        ScatterPlotTests.assertTrue((String)("Expecting the lower bound of the range to be around 10." + range.getLowerBound()), (range.getLowerBound() <= 10.0 ? 1 : 0) != 0);
        ScatterPlotTests.assertTrue((String)("Expecting the upper bound of the range to be around 30:" + range.getUpperBound()), (range.getUpperBound() >= 30.0 ? 1 : 0) != 0);
    }

    private static JFreeChart createChart() {
        XYSeries series1 = new XYSeries("Series 1");
        series1.add(1.0, 1.0);
        series1.add(2.0, 2.0);
        series1.add(3.0, 3.0);
        XYSeriesCollection dataset = new XYSeriesCollection(series1);
        return ChartFactory.createScatterPlot("Scatter Plot", "Domain", "Range", dataset, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class LocalListener
    implements ChartChangeListener {
        boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent event) {
            this.flag = true;
        }
    }
}

