/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.entity;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class ChartEntity {
    protected Shape area;
    protected String toolTipText;

    public ChartEntity(Shape area, String toolTipText) {
        this.area = area;
        this.toolTipText = toolTipText;
    }

    public Shape getArea() {
        return this.area;
    }

    public void setArea(Shape area) {
        this.area = area;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String text) {
        this.toolTipText = this.toolTipText;
    }

    public String getShapeType() {
        if (this.area instanceof Rectangle2D) {
            return "RECT";
        }
        return "POLY";
    }

    public String getShapeCoords() {
        if (this.area instanceof Rectangle2D) {
            return this.getRectCoords((Rectangle2D)this.area);
        }
        return this.getPolyCoords(this.area);
    }

    private String getRectCoords(Rectangle2D rectangle) {
        int x1 = (int)rectangle.getX();
        int y1 = (int)rectangle.getY();
        int x2 = x1 + (int)rectangle.getWidth();
        int y2 = y1 + (int)rectangle.getHeight();
        return x1 + "," + y1 + "," + x2 + "," + y2;
    }

    private String getPolyCoords(Shape shape) {
        String result = "";
        boolean first = true;
        float[] coords = new float[6];
        PathIterator pi = shape.getPathIterator(null, 1.0);
        while (!pi.isDone()) {
            pi.currentSegment(coords);
            if (first) {
                first = false;
                result = result + (int)coords[0] + "," + (int)coords[1];
            } else {
                result = result + "," + (int)coords[0] + "," + (int)coords[1];
            }
            pi.next();
        }
        return result;
    }
}

