/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo.jdbc.swing;

import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Legend;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.demo.jdbc.swing.dbConnection;
import com.jrefinery.data.JdbcXYDataset;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class swingdemo
extends JFrame {
    public boolean isStandalone = false;
    private static final String[] PARAMETERS = new String[]{"A_TEMP_P", "A_TEMP_S", "BAR", "BAR_T", "BIO_RAD", "BIO_TEMP", "DEPTH", "FLU_FLOW", "FLU_VALUE", "GPS_COG", "GPS_SOG", "HUMID_P", "HUMID_S", "LICOR_R", "PITCH_MAX", "PITCH_MIN", "ROLL_MAX", "ROLL_MIN", "SH", "SOLAR_R_P", "SOLAR_R_S", "SS", "TSG_CNDUCT", "TSG_FLOW", "TSG_SALIN", "TSG_TEMP", "UV", "WDPA", "WDPT", "WDSA", "WDST", "WSPA", "WSPT", "WSSA", "WSST", "W_TEMP", "W_TEMP_HI"};
    JFreeChart chart;
    protected Connection conn;
    protected String currentURL = null;
    protected String currentDriver = null;
    protected String currentSchema = "marine";
    protected String currentUser = "dataaccess";
    protected String currentPassword = "dataaccess";
    protected Statement generalStmt;
    protected JdbcXYDataset chartData;
    static final char alphaStart = 'b';
    Vector chartParameters = new Vector();
    protected Thread workingThread;
    JPanel panelHeader = new JPanel();
    JPanel panelGraph = new JPanel();
    JLabel labelCurrentVoyage = new JLabel();
    JLabel textComments = new JLabel();
    JLabel labelChartPickText = new JLabel();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JButton butAction = new JButton();
    JComboBox pickVoyage = new JComboBox();
    JComboBox pickChartItems = new JComboBox();
    BorderLayout borderLayout2 = new BorderLayout();
    GridLayout gridLayout1 = new GridLayout();

    public swingdemo() {
        try {
            this.jbInit();
            this.setupGlassPane();
            this.setDefaultCloseOperation(3);
            this.setupChart();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        swingdemo frame = new swingdemo();
        frame.isStandalone = true;
        frame.processCommandOptions(args);
        frame.start();
    }

    private void jbInit() throws Exception {
        this.setTitle("JFreeChart Demo");
        this.setSize(new Dimension(666, 539));
        this.butAction.setToolTipText("Perform Action");
        this.butAction.setText("Action");
        this.butAction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                swingdemo.this.butAction_actionPerformed();
            }
        });
        this.labelCurrentVoyage.setHorizontalAlignment(11);
        this.labelCurrentVoyage.setText("Current Voyage : ");
        this.panelHeader.setLayout(this.gridLayout1);
        this.textComments.setToolTipText("Comments from last update");
        this.panelGraph.setLayout(this.borderLayout2);
        this.labelChartPickText.setHorizontalAlignment(4);
        this.labelChartPickText.setText("Add / Remove from graph : ");
        this.gridLayout1.setRows(2);
        this.getContentPane().add((Component)this.panelHeader, "North");
        this.panelHeader.add((Component)this.labelCurrentVoyage, null);
        this.panelHeader.add((Component)this.pickVoyage, null);
        this.panelHeader.add((Component)this.textComments, null);
        this.panelHeader.add((Component)this.jLabel1, null);
        this.panelHeader.add((Component)this.labelChartPickText, null);
        this.panelHeader.add((Component)this.pickChartItems, null);
        this.panelHeader.add((Component)this.jLabel2, null);
        this.panelHeader.add((Component)this.butAction, null);
        this.getContentPane().add((Component)this.panelGraph, "Center");
    }

    protected void setupChart() {
        this.chart = ChartFactory.createTimeSeriesChart("Voyage : Not Specified", null, "Records Per Day", null, true);
        Legend legend = this.chart.getLegend();
        legend.setAnchor(2);
        this.chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(Color.darkGray, 1)));
        VerticalNumberAxis vnAxis1 = (VerticalNumberAxis)this.chart.getXYPlot().getRangeAxis();
        vnAxis1.setAutoRangeIncludesZero(false);
        this.panelGraph.add((Component)chartPanel, "Center");
    }

    protected void setupPickLists() {
        this.pickVoyage.addItem("200102040");
        this.pickChartItems.addItem(" ");
        int i = 0;
        while (i < PARAMETERS.length) {
            this.pickChartItems.addItem(PARAMETERS[i]);
            ++i;
        }
    }

    protected void statusMessage(String message) {
        System.out.println("JFreeChart JDBC Swing demo : " + message);
    }

    void butAction_actionPerformed() {
        this.setBusy(true);
        if (this.workingThread != null && this.workingThread.isAlive()) {
            return;
        }
        this.workingThread = null;
        this.statusMessage("Starting graphic refresh");
        this.workingThread = new RefreshChartDataThread();
        if (this.workingThread != null) {
            this.workingThread.start();
        }
    }

    public void start() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setSize(frameSize);
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
        this.setBusy(true);
        if (this.conn == null) {
            this.getDBMSConnection();
        }
        if (this.conn != null) {
            this.setupPickLists();
            this.chartData = new JdbcXYDataset(this.conn);
            this.setBusy(false);
        } else if (this.isStandalone) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void setupGlassPane() {
        Component glassPane = this.getGlassPane();
        glassPane.setCursor(Cursor.getPredefinedCursor(3));
        glassPane.addMouseListener(new MouseListener(){

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    public void setBusy(boolean busy) {
        this.getGlassPane().setVisible(busy);
    }

    protected void getDBMSConnection() {
        Connection connTemp = this.conn;
        this.conn = null;
        dbConnection connData = new dbConnection(false);
        connData.setDriver(this.currentDriver);
        connData.setUserName(this.currentUser);
        connData.setURL(this.currentURL);
        connData.setPassword(this.currentPassword);
        connData.setSchema(this.currentSchema);
        this.conn = connData.showDialog();
        if (this.conn != null) {
            this.currentSchema = connData.getSchema();
            this.currentURL = connData.getURL();
            this.currentUser = connData.getUserName();
            this.currentPassword = connData.getPassword();
        } else {
            this.conn = connTemp;
        }
        Object var2_2 = null;
    }

    public void processCommandOptions(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) == '-') {
                if (args[i].length() < 2) {
                    args[i] = "-?";
                }
                char option = args[i].charAt(1);
                switch (option) {
                    case 'U': {
                        this.currentUser = args[i].substring(2);
                        break;
                    }
                    case 'P': {
                        this.currentPassword = args[i].substring(2);
                        break;
                    }
                    case 'C': {
                        this.currentURL = args[i].substring(2);
                        break;
                    }
                    case 'D': {
                        this.currentDriver = args[i].substring(2);
                        break;
                    }
                    case 'T': {
                        this.currentSchema = args[i].substring(2);
                        if (this.currentSchema == null || this.currentSchema.length() <= 0 || this.currentSchema.endsWith(".")) break;
                        this.currentSchema = this.currentSchema + ".";
                        break;
                    }
                    default: {
                        System.out.println("Usage: ");
                        System.out.println("java " + this.getClass().toString() + " [-Ddriver] [-Cconnect] [-Tschema] [-Uuser] [-Ppassword]");
                        return;
                    }
                }
            }
            ++i;
        }
    }

    static {
        alphaStart = (char)98;
    }

    protected class RefreshChartDataThread
    extends Thread {
        protected RefreshChartDataThread() {
        }

        public void run() {
            String query = null;
            String voyage = null;
            String code = null;
            int i = 0;
            if (swingdemo.this.conn == null) {
                return;
            }
            swingdemo.this.setBusy(true);
            code = swingdemo.this.pickChartItems.getSelectedItem().toString();
            if (swingdemo.this.chartParameters.contains(code)) {
                swingdemo.this.chartParameters.removeElement(code);
            } else if (!code.equals(" ")) {
                swingdemo.this.chartParameters.addElement(code);
            }
            swingdemo.this.pickChartItems.setSelectedIndex(0);
            voyage = swingdemo.this.pickVoyage.getSelectedItem().toString();
            query = "select a.timestamp, a.record_count as Track ";
            i = 0;
            while (i < swingdemo.this.chartParameters.size()) {
                query = query + "," + (char)(98 + i) + ".record_count as " + swingdemo.this.chartParameters.get(i).toString();
                ++i;
            }
            query = query + " from " + swingdemo.this.currentSchema + "summary_track a ";
            i = 0;
            while (i < swingdemo.this.chartParameters.size()) {
                query = query + ", " + swingdemo.this.currentSchema + "summary_data " + (char)(98 + i);
                ++i;
            }
            query = query + " where a.set_code = " + voyage + " and a.timestamp < (select max(timestamp) from " + swingdemo.this.currentSchema + "summary_track where set_code = " + voyage + ")" + " and a.timestamp > (select min(timestamp) from " + swingdemo.this.currentSchema + "summary_track where set_code = " + voyage + ")";
            i = 0;
            while (i < swingdemo.this.chartParameters.size()) {
                query = query + " and a.set_code  = " + (char)(98 + i) + ".set_code  " + " and a.timestamp = " + (char)(98 + i) + ".timestamp " + " and " + (char)(98 + i) + ".obs_code = '" + swingdemo.this.chartParameters.get(i).toString() + "'";
                ++i;
            }
            System.out.println(query);
            try {
                swingdemo.this.chartData.executeQuery(query);
                swingdemo.this.chart.getPlot().setDataset(swingdemo.this.chartData);
                ArrayList<TextTitle> titles = new ArrayList<TextTitle>();
                TextTitle subtitle = new TextTitle("Voyage " + voyage, new Font("SansSerif", 1, 12));
                titles.add(subtitle);
                swingdemo.this.chart.setTitles(titles);
                XYPlot chartPlot = swingdemo.this.chart.getXYPlot();
                ValueAxis chartAxis = chartPlot.getDomainAxis();
                chartAxis.configure();
                chartAxis = chartPlot.getRangeAxis();
                chartAxis.configure();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            swingdemo.this.setBusy(false);
        }
    }
}

