/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo.jdbc.swing;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class dbConnection {
    static String[] ConnectOptionNames = new String[]{"Connect", "Cancel"};
    static String ConnectTitle = "Connection Information";
    String username_ = "marine";
    String driver_ = null;
    String conn_ = null;
    String schema_ = "";
    Dimension origin = new Dimension(0, 0);
    JPanel connectionPanel;
    JLabel userNameLabel;
    JTextField userNameField;
    JLabel passwordLabel;
    JPasswordField passwordField;
    JLabel serverLabel;
    JComboBox serverField;
    JLabel driverLabel;
    JComboBox driverField;
    JLabel schemaLabel;
    JTextField schemaField;
    JLabel[] extraLabels;
    JTextField[] extraFields;
    boolean gotParameters = false;

    public dbConnection() {
        this("Connection Information", null, null, null, new String[0], new String[0], true);
    }

    public dbConnection(boolean activate) {
        this("Connection Information", null, null, null, new String[0], new String[0], activate);
    }

    public dbConnection(String Header, boolean activate) {
        this(Header, null, null, null, new String[0], new String[0], activate);
    }

    public dbConnection(String Header, String username, String url, String driver) {
        this(Header, username, url, driver, new String[0], new String[0], true);
    }

    public dbConnection(String Header, String username, String url, String driver, boolean activate) {
        this(Header, username, url, driver, new String[0], new String[0], activate);
    }

    public dbConnection(String Header, String[] labels, String[] fields) {
        this(Header, null, null, null, labels, fields, true);
    }

    public dbConnection(String Header, String[] labels, String[] fields, boolean activate) {
        this(Header, null, null, null, labels, fields, activate);
    }

    public dbConnection(String Header, String username, String url, String driver, String[] labels, String[] fields, boolean activate) {
        ConnectTitle = Header;
        this.username_ = username;
        this.driver_ = driver;
        this.conn_ = url;
        this.extraLabels = new JLabel[labels.length];
        this.extraFields = new JTextField[labels.length];
        int i = 0;
        while (i < labels.length) {
            this.extraLabels[i] = new JLabel(labels[i], 4);
            this.extraFields[i] = new JTextField(fields[i]);
            ++i;
        }
        this.jbinit();
        if (activate) {
            this.activateConnectionDialog();
        }
    }

    private void jbinit() {
        this.userNameLabel = new JLabel("User name: ", 4);
        this.userNameField = new JTextField();
        this.passwordLabel = new JLabel("Password: ", 4);
        this.passwordField = new JPasswordField();
        this.serverLabel = new JLabel("Database URL: ", 4);
        this.serverField = new JComboBox();
        this.serverField.setEditable(true);
        this.serverField.addItem("jdbc:oracle:thin:@server:1521:PROD");
        this.driverLabel = new JLabel("Driver: ", 4);
        this.driverField = new JComboBox();
        this.driverField.setEditable(true);
        this.driverField.addItem("oracle.jdbc.driver.OracleDriver");
        this.driverField.addItem("postgresql.Driver");
        this.driverField.addItem("com.informix.jdbc.IfxDriver");
        this.schemaLabel = new JLabel("Schema: ", 4);
        this.schemaField = new JTextField();
    }

    public void activateConnectionDialog() {
        int i = 0;
        boolean found = false;
        this.gotParameters = false;
        if (this.username_ != null) {
            this.userNameField.setText(this.username_);
        }
        if (this.conn_ != null) {
            found = false;
            i = 0;
            while (i < this.serverField.getItemCount()) {
                if (this.conn_.equals(this.serverField.getItemAt(i).toString())) {
                    found = true;
                    this.serverField.setSelectedIndex(i);
                    i = this.serverField.getItemCount();
                }
                ++i;
            }
            if (!found) {
                this.serverField.addItem(this.conn_);
                this.serverField.setSelectedIndex(this.serverField.getItemCount() - 1);
            }
        }
        if (this.driver_ != null) {
            found = false;
            i = 0;
            while (i < this.driverField.getItemCount()) {
                if (this.driver_.equals(this.driverField.getItemAt(i).toString())) {
                    found = true;
                    this.driverField.setSelectedIndex(i);
                    i = this.driverField.getItemCount();
                }
                ++i;
            }
            if (!found) {
                this.driverField.addItem(this.driver_);
                this.driverField.setSelectedIndex(this.driverField.getItemCount() - 1);
            }
        }
        this.schemaField.setText(this.schema_);
        this.connectionPanel = new JPanel(false);
        this.connectionPanel.setLayout(new BoxLayout(this.connectionPanel, 0));
        JPanel namePanel = new JPanel(false);
        namePanel.setLayout(new GridLayout(0, 1));
        namePanel.add(this.userNameLabel);
        namePanel.add(this.passwordLabel);
        namePanel.add(this.serverLabel);
        namePanel.add(this.driverLabel);
        namePanel.add(this.schemaLabel);
        i = 0;
        while (i < this.extraLabels.length) {
            namePanel.add(this.extraLabels[i]);
            ++i;
        }
        JPanel fieldPanel = new JPanel(false);
        fieldPanel.setLayout(new GridLayout(0, 1));
        fieldPanel.add(this.userNameField);
        fieldPanel.add(this.passwordField);
        fieldPanel.add(this.serverField);
        fieldPanel.add(this.driverField);
        fieldPanel.add(this.schemaField);
        i = 0;
        while (i < this.extraFields.length) {
            fieldPanel.add(this.extraFields[i]);
            ++i;
        }
        this.connectionPanel.add(namePanel);
        this.connectionPanel.add(fieldPanel);
        if (JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), this.connectionPanel, ConnectTitle, -1, 1, null, ConnectOptionNames, ConnectOptionNames[0]) == 0) {
            this.gotParameters = true;
            this.username_ = this.userNameField.getText();
            this.driver_ = this.driverField.getSelectedItem().toString();
            this.conn_ = this.serverField.getSelectedItem().toString();
        }
    }

    public Connection showDialog() {
        int i = 0;
        Connection conn = null;
        while (i < 3 && conn == null) {
            ++i;
            this.activateConnectionDialog();
            if (this.gotParameters()) {
                try {
                    Class.forName(this.driverField.getSelectedItem().toString());
                    conn = DriverManager.getConnection(this.serverField.getSelectedItem().toString(), this.userNameField.getText(), this.getPassword());
                }
                catch (ClassNotFoundException nf) {
                    System.err.println(" JDBC driver not found - check CLASSPATH!");
                }
                catch (SQLException sqle) {
                    System.err.println(" Unable to connect to the specified database!");
                }
                continue;
            }
            i = 4;
        }
        return conn;
    }

    public void setDefaults(String driver, String user, String url, String password, String schema) {
        this.setDriver(driver);
        this.setUserName(user);
        this.setURL(url);
        this.setPassword(password);
        this.setSchema(schema);
    }

    public String getUserName() {
        return this.userNameField.getText();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public String getURL() {
        return this.serverField.getSelectedItem().toString();
    }

    public String getDriver() {
        return this.driverField.getSelectedItem().toString();
    }

    public String getSchema() {
        this.schema_ = this.schemaField.getText();
        if (this.schema_ == null || this.schema_.length() < 1) {
            this.schema_ = this.getUserName();
        }
        if (!this.schema_.endsWith(".") && this.schema_.length() > 0) {
            this.schema_ = this.schema_ + ".";
        }
        this.schemaField.setText(this.schema_);
        return this.schema_;
    }

    public void setSchema(String schema) {
        if (schema != null) {
            this.schemaField.setText(schema);
            this.getSchema();
        }
    }

    public void setDriver(String driver) {
        boolean found = false;
        if (driver == null) {
            return;
        }
        int i = 0;
        while (i < this.driverField.getItemCount()) {
            if (this.driverField.getItemAt(i).toString().toLowerCase().equals(driver.toLowerCase())) {
                this.driverField.setSelectedIndex(i);
                found = true;
                i = this.driverField.getItemCount();
            }
            ++i;
        }
        if (!found) {
            this.driverField.addItem(driver);
            this.driverField.setSelectedItem(driver);
        }
        this.driver_ = driver;
    }

    public void setURL(String url) {
        boolean found = false;
        if (url == null) {
            return;
        }
        int i = 0;
        while (i < this.serverField.getItemCount()) {
            if (this.serverField.getItemAt(i).toString().toLowerCase().equals(url.toLowerCase())) {
                this.serverField.setSelectedIndex(i);
                found = true;
                i = this.serverField.getItemCount();
            }
            ++i;
        }
        if (!found) {
            this.serverField.addItem(url);
            this.serverField.setSelectedItem(url);
        }
        this.conn_ = url;
    }

    public void setUserName(String name) {
        if (name == null) {
            return;
        }
        this.username_ = name;
        this.userNameField.setText(name);
    }

    public void setPassword(String password) {
        if (password == null) {
            this.passwordField.setText("");
        } else {
            this.passwordField.setText(password);
        }
    }

    public String getField(int i) {
        return this.extraFields[i].getText();
    }

    public boolean gotParameters() {
        return this.gotParameters;
    }

    public static void main(String[] s) {
        new dbConnection();
    }
}

