/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo.jdbc.servlet;

import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.demo.jdbc.servlet.BaseImageServlet;
import java.awt.Font;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class ImageDemoPie
extends BaseImageServlet {
    public void init(ServletConfig config) throws ServletException {
        this.servletName = "Servlet ImagePie";
        super.init(config);
    }

    protected String generateSQL(HttpServletRequest request) {
        String plotYear;
        String plotMonth;
        String plotDay;
        String voyage;
        String query = null;
        try {
            voyage = request.getParameter("voyage");
        }
        catch (Exception e) {
            voyage = "200102040";
        }
        try {
            plotDay = request.getParameter("date");
        }
        catch (Exception e) {
            plotDay = "05";
        }
        try {
            plotMonth = request.getParameter("month");
        }
        catch (Exception e) {
            plotMonth = "01";
        }
        try {
            plotYear = request.getParameter("year");
        }
        catch (Exception e) {
            plotYear = "2002";
        }
        switch (this.sqlServerType) {
            case 1: {
                query = " and timestamp = '" + plotYear + "-" + plotMonth + "-" + plotDay + " 00:00:00'";
                break;
            }
            default: {
                query = " and timestamp = to_date('" + plotYear + "-" + plotMonth + "-" + plotDay + "', 'yyyy-mon-dd')";
            }
        }
        query = "select obs_code, record_count from " + this.dbSchema_ + "summary_data" + " where set_code = " + voyage + query;
        if (this.debug) {
            System.out.println(": " + query);
        }
        return query;
    }

    public void modifyChart(JFreeChart chart, HttpServletRequest request) {
        String title = null;
        try {
            title = request.getParameter("title");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (title == null || title.length() < 2) {
            String plotYear;
            String plotMonth;
            String plotDay;
            String voyage;
            try {
                voyage = request.getParameter("voyage");
            }
            catch (Exception e) {
                voyage = "200102040";
            }
            try {
                plotDay = request.getParameter("date");
            }
            catch (Exception e) {
                plotDay = "05";
            }
            try {
                plotMonth = request.getParameter("month");
            }
            catch (Exception e) {
                plotMonth = "01";
            }
            try {
                plotYear = request.getParameter("year");
            }
            catch (Exception e) {
                plotYear = "2002";
            }
            title = "Voyage " + voyage + " on " + plotYear + "-" + plotMonth + "-" + plotDay;
            if (chart != null) {
                ArrayList<TextTitle> titles = new ArrayList<TextTitle>();
                TextTitle subtitle = new TextTitle(title, new Font("SansSerif", 1, 12));
                titles.add(subtitle);
                chart.setTitles(titles);
            }
        }
    }
}

