/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartFrame;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.XYStepRenderer;
import com.jrefinery.data.DefaultXYDataset;
import com.jrefinery.data.XYDataset;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class XYStepChartDemo {
    private ChartFrame frame = null;

    public static JFreeChart createXYStepChart(String title, String xAxisLabel, String yAxisLabel, XYDataset data, boolean legend) {
        HorizontalDateAxis xAxis = new HorizontalDateAxis(xAxisLabel);
        VerticalNumberAxis yAxis = new VerticalNumberAxis(yAxisLabel);
        xAxis.setCrosshairVisible(false);
        yAxis.setAutoTickUnitSelection(false);
        yAxis.setTickUnit(new NumberTickUnit(1.0, new DecimalFormat("0")));
        yAxis.setCrosshairVisible(false);
        XYPlot plot = new XYPlot(data, xAxis, yAxis);
        Stroke[] s = new BasicStroke[]{new BasicStroke(2.0f), new BasicStroke(2.0f)};
        plot.setSeriesStroke(s);
        plot.setXYItemRenderer(new XYStepRenderer());
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    private void displayXYPlot() {
        if (this.frame == null) {
            String title = "LCACs in use at given time";
            String xAxisLabel = "Time";
            String yAxisLabel = "Number of Transports";
            XYDataset data1 = this.createTestXYDataset();
            JFreeChart chart = XYStepChartDemo.createXYStepChart(title, xAxisLabel, yAxisLabel, data1, true);
            chart.setBackgroundPaint(new Color(216, 216, 216));
            this.frame = new ChartFrame("Plan Comparison", chart);
            this.frame.pack();
            RefineryUtilities.positionFrameRandomly(this.frame);
            this.frame.show();
        } else {
            this.frame.show();
            this.frame.requestFocus();
        }
    }

    private Date createDateTime(int year, int month, int day, int hour, int minute) {
        GregorianCalendar calendar = new GregorianCalendar(year, month, day, hour, minute);
        return calendar.getTime();
    }

    public XYDataset createTestXYDataset() {
        String[] sNames = new String[]{"Plan 1", "Plan 2"};
        Object[][][] data = new Object[][][]{{{this.createDateTime(2002, 1, 19, 8, 0), new Integer(0)}, {this.createDateTime(2002, 1, 19, 8, 0), new Integer(2)}, {this.createDateTime(2002, 1, 19, 9, 5), new Integer(4)}, {this.createDateTime(2002, 1, 19, 10, 6), new Integer(4)}, {this.createDateTime(2002, 1, 19, 11, 6), new Integer(5)}, {this.createDateTime(2002, 1, 19, 12, 6), new Integer(3)}, {this.createDateTime(2002, 1, 19, 13, 6), new Integer(6)}, {this.createDateTime(2002, 1, 19, 14, 6), new Integer(6)}, {this.createDateTime(2002, 1, 19, 15, 30), new Integer(2)}, {this.createDateTime(2002, 1, 19, 16, 7), new Integer(0)}}, {{this.createDateTime(2002, 1, 19, 8, 45), new Integer(0)}, {this.createDateTime(2002, 1, 19, 8, 45), new Integer(1)}, {this.createDateTime(2002, 1, 19, 9, 0), new Integer(6)}, {this.createDateTime(2002, 1, 19, 10, 6), new Integer(2)}, {this.createDateTime(2002, 1, 19, 10, 45), new Integer(4)}, {this.createDateTime(2002, 1, 19, 12, 0), new Integer(7)}, {this.createDateTime(2002, 1, 19, 13, 0), new Integer(5)}, {this.createDateTime(2002, 1, 19, 14, 6), new Integer(4)}, {this.createDateTime(2002, 1, 19, 15, 15), new Integer(4)}, {this.createDateTime(2002, 1, 19, 16, 0), new Integer(0)}}};
        DefaultXYDataset d = new DefaultXYDataset(data);
        d.setSeriesNames(sNames);
        return d;
    }

    public static void main(String[] args) {
        XYStepChartDemo demo = new XYStepChartDemo();
        demo.displayXYPlot();
    }
}

