/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.VerticalLogarithmicAxis;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.ui.ApplicationFrame;
import java.awt.Color;
import java.awt.Paint;

public class VerticalBarChartDemo
extends ApplicationFrame {
    protected CategoryDataset data;

    public VerticalBarChartDemo(String title) {
        super(title);
        double[][] data = new double[][]{{100.0, -100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0}, {100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0}, {100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0}};
        DefaultCategoryDataset dataset = new DefaultCategoryDataset(data);
        dataset.setSeriesName(0, "First");
        dataset.setSeriesName(1, "Second");
        dataset.setSeriesName(2, "Third");
        Object[] categories = new String[]{"Type 1", "Type 2", "Type 3", "Type 4", "Type 5", "Type 6", "Type 7", "Type 8"};
        dataset.setCategories(categories);
        JFreeChart chart = ChartFactory.createVerticalBarChart("Vertical Bar Chart", "Category", "Value", dataset, true);
        chart.setBackgroundPaint(Color.yellow);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setSeriesPaint(new Paint[]{Color.green, Color.orange, Color.red});
        HorizontalCategoryAxis domainAxis = (HorizontalCategoryAxis)plot.getDomainAxis();
        domainAxis.setVerticalCategoryLabels(true);
        VerticalLogarithmicAxis rangeAxis = new VerticalLogarithmicAxis("Log(value)");
        plot.setRangeAxis(rangeAxis);
        ChartPanel chartPanel = new ChartPanel(chart);
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        VerticalBarChartDemo demo = new VerticalBarChartDemo("Vertical Bar Chart Demo");
        demo.pack();
        demo.setVisible(true);
    }
}

