/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.YisSymbolic;
import java.lang.reflect.Array;
import java.util.Vector;

public class SampleYSymbolicDataset
extends AbstractSeriesDataset
implements XYDataset,
YisSymbolic {
    private static final int DEFAULT_SERIES_COUNT = 1;
    private static final int DEFAULT_ITEM_COUNT = 50;
    private int serie;
    private int item;
    private String[] serieNames;
    private Double[][] xValues;
    private Integer[][] yValues;
    private String[] ySymbolicValues;
    private String datasetName;

    public SampleYSymbolicDataset(String datasetName, int xRange, String[] tabString) {
        this(datasetName, xRange, tabString, 1, 50, null);
    }

    public SampleYSymbolicDataset(String datasetName, int xRange, String[] tabString, int serie, int item, String[] serieNames) {
        this.datasetName = datasetName;
        this.ySymbolicValues = tabString;
        this.serie = serie;
        this.item = item;
        this.serieNames = serieNames;
        this.xValues = new Double[serie][item];
        this.yValues = new Integer[serie][item];
        int s = 0;
        while (s < serie) {
            int i = 0;
            while (i < item) {
                double x = Math.random() * (double)xRange;
                double y = Math.random() * (double)tabString.length;
                this.xValues[s][i] = new Double(x);
                this.yValues[s][i] = new Integer((int)y);
                ++i;
            }
            ++s;
        }
    }

    public SampleYSymbolicDataset(String datasetName, Double[][] xValues, Integer[][] yValues, String[] ySymbolicValues, int serie, int item, String[] serieNames) {
        this.datasetName = datasetName;
        this.xValues = xValues;
        this.yValues = yValues;
        this.ySymbolicValues = ySymbolicValues;
        this.serie = serie;
        this.item = item;
        this.serieNames = serieNames;
    }

    public Number getXValue(int series, int item) {
        return this.xValues[series][item];
    }

    public Number getYValue(int series, int item) {
        return this.yValues[series][item];
    }

    public void setYValue(int series, int item, Number newValue) {
        this.yValues[series][item] = (Integer)newValue;
    }

    public int getSeriesCount() {
        return this.serie;
    }

    public String getSeriesName(int series) {
        if (this.serieNames != null) {
            return this.serieNames[series];
        }
        return this.datasetName + series;
    }

    public int getItemCount(int series) {
        return this.item;
    }

    public String[] getYSymbolicValues() {
        return this.ySymbolicValues;
    }

    public void setYSymbolicValues(String[] sValues) {
        this.ySymbolicValues = sValues;
    }

    public String getYSymbolicValue(int series, int item) {
        Integer intValue = (Integer)this.getYValue(series, item);
        return this.getYSymbolicValue(intValue);
    }

    public String getYSymbolicValue(Integer val) {
        return this.ySymbolicValues[val];
    }

    public static String[] combineYSymbolicDataset(YisSymbolic dataset1, YisSymbolic dataset2) {
        SampleYSymbolicDataset sDataset1 = (SampleYSymbolicDataset)dataset1;
        SampleYSymbolicDataset sDataset2 = (SampleYSymbolicDataset)dataset2;
        String[] sDatasetSymbolicValues1 = sDataset1.getYSymbolicValues();
        String[] sDatasetSymbolicValues2 = sDataset2.getYSymbolicValues();
        int s1length = sDatasetSymbolicValues1.length;
        int s2length = sDatasetSymbolicValues2.length;
        Vector<String> ySymbolicValuesCombined = new Vector<String>();
        int i = 0;
        while (i < s1length) {
            ySymbolicValuesCombined.add(sDatasetSymbolicValues1[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < s2length) {
            if (!ySymbolicValuesCombined.contains(sDatasetSymbolicValues2[i2])) {
                ySymbolicValuesCombined.add(sDatasetSymbolicValues2[i2]);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < sDataset2.getSeriesCount()) {
            int j = 0;
            while (j < sDataset2.getItemCount(i3)) {
                int newIndex = ySymbolicValuesCombined.indexOf(sDataset2.getYSymbolicValue(i3, j));
                sDataset2.setYValue(i3, j, new Integer(newIndex));
                ++j;
            }
            ++i3;
        }
        String[] ySymbolicValuesCombinedA = new String[ySymbolicValuesCombined.size()];
        ySymbolicValuesCombined.toArray(ySymbolicValuesCombinedA);
        sDataset1.setYSymbolicValues(ySymbolicValuesCombinedA);
        sDataset2.setYSymbolicValues(ySymbolicValuesCombinedA);
        return ySymbolicValuesCombinedA;
    }

    public Object clone() {
        String nDatasetName = new String(this.datasetName);
        Double[][] nXValues = (Double[][])SampleYSymbolicDataset.cloneArray(this.xValues);
        Integer[][] nYValues = (Integer[][])SampleYSymbolicDataset.cloneArray(this.yValues);
        String[] nYSymbolicValues = (String[])SampleYSymbolicDataset.cloneArray(this.ySymbolicValues);
        int serie = this.serie;
        int item = this.item;
        String[] serieNames = (String[])SampleYSymbolicDataset.cloneArray(this.serieNames);
        return new SampleYSymbolicDataset(nDatasetName, nXValues, nYValues, nYSymbolicValues, serie, item, serieNames);
    }

    private static Object cloneArray(Object arr) {
        if (arr == null) {
            return arr;
        }
        Class<?> cls = arr.getClass();
        if (!cls.isArray()) {
            return arr;
        }
        int length = Array.getLength(arr);
        Object[] newarr = (Object[])Array.newInstance(cls.getComponentType(), length);
        int i = 0;
        while (i < length) {
            Object obj = Array.get(arr, i);
            newarr[i] = obj.getClass().isArray() ? SampleYSymbolicDataset.cloneArray(obj) : obj;
            ++i;
        }
        return newarr;
    }

    static {
        DEFAULT_SERIES_COUNT = 1;
        DEFAULT_ITEM_COUNT = 50;
    }
}

