/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.LineAndShapeRenderer;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.OverlaidVerticalCategoryPlot;
import com.jrefinery.chart.SeriesShapeFactory;
import com.jrefinery.chart.VerticalCategoryPlot;
import com.jrefinery.chart.VerticalIntervalBarRenderer;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.data.DefaultIntervalCategoryDataset;
import com.jrefinery.ui.ApplicationFrame;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;

public class OverlaidCategoryChartDemo
extends ApplicationFrame {
    private static final String[] categories = new String[]{"1", "3", "5", "10", "20"};
    private static Color[] barColors = null;
    private static Color[] dotColors = null;
    private static Color[] lineColors = null;
    private static Font labelFont = null;
    private static Font boldLabelFont = null;
    private static Font titleFont = null;
    private JFreeChart chart = null;

    public OverlaidCategoryChartDemo(String title) {
        super(title);
        DefaultIntervalCategoryDataset barData = null;
        double[][] lows = new double[][]{{-0.0315, 0.0159, 0.0306, 0.0453, 0.0557}};
        double[][] highs = new double[][]{{0.1931, 0.1457, 0.131, 0.1163, 0.1059}};
        barData = new DefaultIntervalCategoryDataset(lows, highs);
        DefaultCategoryDataset dotData = null;
        double[][] vals = new double[][]{{0.0808, 0.0808, 0.0808, 0.0808, 0.0808}};
        dotData = new DefaultCategoryDataset(vals);
        DefaultCategoryDataset lineData = null;
        double[][] lineVals = new double[4][5];
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 5) {
                lineVals[i][j] = Math.random() * 0.56 - 0.18;
                ++j;
            }
            ++i;
        }
        lineData = new DefaultCategoryDataset(lineVals);
        String ctitle = "Strategie Sicherheit";
        String xTitle = "Zeitraum (in Jahren)";
        String yTitle = "Performance";
        HorizontalCategoryAxis xAxis = new HorizontalCategoryAxis(xTitle);
        xAxis.setLabelFont(titleFont);
        xAxis.setTickLabelFont(labelFont);
        xAxis.setTickMarksVisible(false);
        VerticalNumberAxis yAxis = new VerticalNumberAxis(yTitle);
        yAxis.setLabelFont(titleFont);
        yAxis.setTickLabelFont(labelFont);
        yAxis.setMinimumAxisValue(-0.2);
        yAxis.setMaximumAxisValue(0.4);
        DecimalFormat formatter = new DecimalFormat("0.##%");
        yAxis.setTickUnit(new NumberTickUnit(0.05, formatter));
        OverlaidVerticalCategoryPlot plot = new OverlaidVerticalCategoryPlot(xAxis, yAxis, (Object[])categories);
        plot.setBackgroundPaint(Color.lightGray);
        plot.setOutlinePaint(Color.black);
        VerticalIntervalBarRenderer barRenderer = null;
        barRenderer = new VerticalIntervalBarRenderer();
        VerticalCategoryPlot bars = null;
        bars = new VerticalCategoryPlot(barData, null, null, barRenderer);
        bars.setLabelsVisible(true);
        bars.setLabelFont(labelFont);
        bars.setLabelFormatString("0.##%");
        bars.setSeriesPaint(barColors);
        plot.add(bars);
        LineAndShapeRenderer dotRenderer = null;
        dotRenderer = new LineAndShapeRenderer(1, 4);
        VerticalCategoryPlot dots = null;
        dots = new VerticalCategoryPlot(dotData, null, null, dotRenderer);
        dots.setLabelsVisible(true);
        dots.setLabelFont(boldLabelFont);
        dots.setLabelPaint(Color.white);
        dots.setLabelFormatString("0.##%");
        dots.setSeriesPaint(dotColors);
        dots.setShapeFactory(new SeriesShapeFactory());
        plot.add(dots);
        LineAndShapeRenderer lineRenderer = null;
        lineRenderer = new LineAndShapeRenderer(3);
        VerticalCategoryPlot lines = null;
        lines = new VerticalCategoryPlot(lineData, null, null, lineRenderer);
        lines.setSeriesPaint(lineColors);
        lines.setShapeFactory(new SeriesShapeFactory());
        plot.add(lines);
        this.chart = new JFreeChart(ctitle, titleFont, plot, false);
        this.chart.setBackgroundPaint(Color.white);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        OverlaidCategoryChartDemo demo = new OverlaidCategoryChartDemo("Overlaid Category Chart Demo");
        demo.pack();
        demo.setVisible(true);
    }

    static {
        barColors = new Color[1];
        OverlaidCategoryChartDemo.barColors[0] = new Color(51, 102, 153);
        dotColors = new Color[1];
        OverlaidCategoryChartDemo.dotColors[0] = Color.white;
        lineColors = new Color[4];
        OverlaidCategoryChartDemo.lineColors[0] = Color.red;
        OverlaidCategoryChartDemo.lineColors[1] = Color.blue;
        OverlaidCategoryChartDemo.lineColors[2] = Color.yellow;
        OverlaidCategoryChartDemo.lineColors[3] = Color.magenta;
        labelFont = new Font("Helvetica", 0, 10);
        boldLabelFont = new Font("Helvetica", 1, 10);
        titleFont = new Font("Helvetica", 1, 14);
    }
}

