/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.XYSeries;
import com.jrefinery.data.XYSeriesCollection;
import com.jrefinery.ui.ApplicationFrame;
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.URL;
import javax.swing.ImageIcon;

public class MultiShapesXYDemo
extends ApplicationFrame {
    protected XYSeries series;
    private static final int numPoints = 200;
    private static final double inc = 0.1;
    private static final float R1 = 0.0f;
    private static final float G1 = 1.0f;
    private static final float B1 = 0.0f;
    private static final float R2 = 1.0f;
    private static final float G2 = 0.0f;
    private static final float B2 = 0.0f;
    private Image ballImage;
    private Image arrowImage;

    public MultiShapesXYDemo(String title) {
        super(title);
        URL url1 = this.getClass().getClassLoader().getResource("com/jrefinery/chart/demo/redball.png");
        URL url2 = this.getClass().getClassLoader().getResource("com/jrefinery/chart/demo/arrow.png");
        if (url1 != null && url2 != null) {
            this.ballImage = new ImageIcon(url1).getImage();
            this.arrowImage = new ImageIcon(url2).getImage();
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(this.ballImage, 0);
            tracker.addImage(this.arrowImage, 1);
            try {
                tracker.waitForID(0);
                tracker.waitForID(1);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("Images loaded");
        } else {
            System.err.println("Can't find images");
        }
        this.series = new XYSeries("Some Data");
        int i = 0;
        while (i < 200) {
            double x = 0.1 * (double)i;
            double y = Math.sin(x);
            this.series.add(x, y);
            ++i;
        }
        XYSeriesCollection data = new XYSeriesCollection(this.series);
        HorizontalNumberAxis domainAxis = new HorizontalNumberAxis("x");
        VerticalNumberAxis rangeAxis = new VerticalNumberAxis("sin(x)");
        DemoRenderer renderer = new DemoRenderer();
        XYPlot plot = new XYPlot(data, domainAxis, rangeAxis, renderer);
        JFreeChart chart = new JFreeChart(plot);
        ChartPanel chartPanel = new ChartPanel(chart);
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        MultiShapesXYDemo demo = new MultiShapesXYDemo("XY Plot With Multiple Shapes");
        demo.pack();
        demo.setVisible(true);
    }

    static {
        numPoints = 200;
        inc = 0.1;
        R1 = 0.0f;
        G1 = 1.0f;
        B1 = 0.0f;
        R2 = 1.0f;
        G2 = 0.0f;
        B2 = 0.0f;
    }

    class DemoRenderer
    extends StandardXYItemRenderer {
        public DemoRenderer() {
            super(5, null);
        }

        protected boolean isShapeFilled(Plot plot, int series, int item, double x, double y) {
            return item % 2 == 0;
        }

        protected double getShapeScale(Plot plot, int series, int item, double x, double y) {
            float rat = (float)item / 200.0f;
            return 6.0 - (double)rat * 4.0;
        }

        protected Paint getPaint(Plot plot, int series, int item, double x, double y) {
            float rat = (float)item / 200.0f;
            float R = (1.0f - rat) * 0.0f + rat * 1.0f;
            float G = (1.0f - rat) * 1.0f + rat * 0.0f;
            float B = (1.0f - rat) * 0.0f + rat * 0.0f;
            Color c = new Color(R, G, B);
            return c;
        }

        protected Shape getShape(Plot plot, int series, int item, double x, double y, double scale) {
            RectangularShape shape;
            switch (item % 2) {
                case 0: {
                    shape = new Rectangle2D.Double(x - 0.5 * scale, y - 0.5 * scale, scale, scale);
                    break;
                }
                default: {
                    shape = new Ellipse2D.Double(x - 0.5 * scale, y - 0.5 * scale, scale, scale);
                }
            }
            return shape;
        }

        protected Image getImage(Plot plot, int series, int item, double x, double y) {
            if (item % 10 == 0) {
                return MultiShapesXYDemo.this.ballImage;
            }
            if (item == 42) {
                return MultiShapesXYDemo.this.arrowImage;
            }
            return null;
        }

        protected Point getImageHotspot(Plot plot, int series, int item, double x, double y, Image image) {
            if (image == MultiShapesXYDemo.this.arrowImage) {
                return new Point(0, image.getHeight(null));
            }
            return super.getImageHotspot(plot, series, item, x, y, image);
        }
    }
}

