/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartMouseEvent;
import com.jrefinery.chart.ChartMouseListener;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.demo.DemoDatasetFactory;
import com.jrefinery.chart.entity.ChartEntity;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.ui.ApplicationFrame;
import java.awt.Color;

public class MouseListenerDemo2
extends ApplicationFrame
implements ChartMouseListener {
    public MouseListenerDemo2(String title) {
        super(title);
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createVerticalBarChart("Test", "Category", "Value", data, true);
        chart.setBackgroundPaint(Color.orange);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.addChartMouseListener(this);
        this.setContentPane(chartPanel);
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        ChartEntity entity = event.getEntity();
        if (entity != null) {
            System.out.println(entity.toString());
        } else {
            System.out.println("Null entity.");
        }
    }

    public void chartMouseMoved(ChartMouseEvent event) {
        int x = event.getTrigger().getX();
        int y = event.getTrigger().getY();
        ChartEntity entity = event.getEntity();
        if (entity != null) {
            System.out.println("Location: " + x + ", " + y + ": " + entity.toString());
        } else {
            System.out.println("Location: " + x + ", " + y + ": null entity.");
        }
    }

    public static void main(String[] args) {
        MouseListenerDemo2 demo = new MouseListenerDemo2("Mouse Listener Demo 2");
        demo.pack();
        demo.setVisible(true);
    }
}

