/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartMouseEvent;
import com.jrefinery.chart.ChartMouseListener;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.entity.ChartEntity;
import com.jrefinery.data.DefaultPieDataset;
import com.jrefinery.ui.ApplicationFrame;
import java.awt.Color;

public class MouseListenerDemo1
extends ApplicationFrame
implements ChartMouseListener {
    public MouseListenerDemo1(String title) {
        super(title);
        DefaultPieDataset data = new DefaultPieDataset();
        data.setValue("Java", new Double(43.2));
        data.setValue("Visual Basic", new Double(0.0));
        data.setValue("C/C++", new Double(17.5));
        JFreeChart chart = ChartFactory.createPieChart("Pie Chart Demo 1", data, true);
        chart.setBackgroundPaint(Color.yellow);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.addChartMouseListener(this);
        this.setContentPane(chartPanel);
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        ChartEntity entity = event.getEntity();
        if (entity != null) {
            System.out.println(entity.toString());
        } else {
            System.out.println("Null entity.");
        }
    }

    public void chartMouseMoved(ChartMouseEvent event) {
        int x = event.getTrigger().getX();
        int y = event.getTrigger().getY();
        ChartEntity entity = event.getEntity();
        if (entity != null) {
            System.out.println("Location: " + x + ", " + y + ": " + entity.toString());
        } else {
            System.out.println("Location: " + x + ", " + y + ": null entity.");
        }
    }

    public static void main(String[] args) {
        MouseListenerDemo1 demo = new MouseListenerDemo1("Mouse Listener Demo");
        demo.pack();
        demo.setVisible(true);
    }
}

