/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartFrame;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.VerticalCategoryPlot;
import com.jrefinery.chart.VerticalIntervalBarRenderer;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.data.DefaultIntervalCategoryDataset;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.Locale;

public class IntervalBarChartDemo {
    private static final String[] categories = new String[]{"1", "3", "5", "10", "20"};
    private static Color[] dataColors = null;
    private static Font labelFont = null;
    private static Font titleFont = null;
    private JFreeChart chart = null;

    public IntervalBarChartDemo() {
        DefaultIntervalCategoryDataset data = null;
        double[][] lows = new double[][]{{-0.0315, 0.0159, 0.0306, 0.0453, 0.0557}};
        double[][] highs = new double[][]{{0.1931, 0.1457, 0.131, 0.1163, 0.1059}};
        data = new DefaultIntervalCategoryDataset(lows, highs);
        data.setCategories(categories);
        String title = "Strategie Sicherheit";
        String xTitle = "Zeitraum (in Jahren)";
        String yTitle = "Performance";
        HorizontalCategoryAxis xAxis = new HorizontalCategoryAxis(xTitle);
        xAxis.setLabelFont(titleFont);
        xAxis.setTickLabelFont(labelFont);
        xAxis.setTickMarksVisible(false);
        VerticalNumberAxis yAxis = new VerticalNumberAxis(yTitle);
        yAxis.setLabelFont(titleFont);
        yAxis.setTickLabelFont(labelFont);
        yAxis.setMinimumAxisValue(-0.2);
        yAxis.setMaximumAxisValue(0.4);
        DecimalFormat formatter = new DecimalFormat("0.##%");
        yAxis.setTickUnit(new NumberTickUnit(0.05, formatter));
        VerticalIntervalBarRenderer renderer = null;
        renderer = new VerticalIntervalBarRenderer();
        VerticalCategoryPlot plot = null;
        plot = new VerticalCategoryPlot(data, xAxis, yAxis, renderer);
        plot.setLabelFont(labelFont);
        plot.setLabelFormatString("0.##%");
        plot.setBackgroundPaint(Color.lightGray);
        plot.setOutlinePaint(Color.white);
        plot.setSeriesPaint(dataColors);
        this.chart = new JFreeChart(title, titleFont, plot, false);
        this.chart.setBackgroundPaint(Color.white);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public static void main(String[] args) {
        Locale.setDefault(Locale.GERMANY);
        IntervalBarChartDemo sample = new IntervalBarChartDemo();
        JFreeChart chart = sample.getChart();
        ChartFrame frame = new ChartFrame("Interval Bar Chart Demo", chart);
        frame.pack();
        frame.setVisible(true);
    }

    static {
        dataColors = new Color[1];
        IntervalBarChartDemo.dataColors[0] = new Color(51, 102, 153);
        labelFont = new Font("Helvetica", 0, 10);
        titleFont = new Font("Helvetica", 1, 14);
    }
}

