/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.HorizontalMarkerAxisBand;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.IntervalMarker;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.TickUnits;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.ui.ApplicationFrame;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;

public class HorizontalBarChartDemo
extends ApplicationFrame {
    protected CategoryDataset data;

    public HorizontalBarChartDemo(String title) {
        super(title);
        double[][] data = new double[][]{{1.0, 43.0, 35.0, 58.0, 54.0, 77.0, 71.0, 89.0}, {54.0, 75.0, 63.0, 83.0, 43.0, 46.0, 27.0, 13.0}, {41.0, 33.0, 22.0, 34.0, 62.0, 32.0, 42.0, 34.0}};
        DefaultCategoryDataset dataset = new DefaultCategoryDataset(data);
        dataset.setSeriesName(0, "First");
        dataset.setSeriesName(1, "Second");
        dataset.setSeriesName(2, "Third");
        Object[] categories = new String[]{"Factor 1", "Factor 2", "Factor 3", "Factor 4", "Factor 5", "Factor 6", "Factor 7", "Factor 8"};
        dataset.setCategories(categories);
        JFreeChart chart = ChartFactory.createHorizontalBarChart("Horizontal Bar Chart", "Category", "Score (%)", dataset, true);
        chart.setBackgroundPaint(Color.lightGray);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setSeriesPaint(new Paint[]{new Color(0, 0, 255), new Color(75, 75, 255), new Color(150, 150, 255)});
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setRange(0.0, 100.0);
        rangeAxis.setStandardTickUnits(TickUnits.createIntegerTickUnits());
        HorizontalNumberAxis hna = (HorizontalNumberAxis)rangeAxis;
        HorizontalMarkerAxisBand band = new HorizontalMarkerAxisBand(hna, 2.0, 2.0, 2.0, 2.0, new Font("SansSerif", 0, 9));
        IntervalMarker m1 = new IntervalMarker(0.0, 33.0, "Low", Color.gray, Color.green, 0.75f);
        IntervalMarker m2 = new IntervalMarker(33.0, 66.0, "Medium", Color.gray, Color.orange, 0.75f);
        IntervalMarker m3 = new IntervalMarker(66.0, 100.0, "High", Color.gray, Color.red, 0.75f);
        band.addMarker(m1);
        band.addMarker(m2);
        band.addMarker(m3);
        hna.setMarkerBand(band);
        ChartPanel chartPanel = new ChartPanel(chart);
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        HorizontalBarChartDemo demo = new HorizontalBarChartDemo("Horizontal Bar Chart Demo");
        demo.pack();
        demo.setVisible(true);
    }
}

