/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.data;

import com.jrefinery.chart.data.PlotFitAlgorithm;
import com.jrefinery.data.DefaultXYDataset;
import com.jrefinery.data.XYDataset;

public class PlotFit {
    protected XYDataset dataset;
    protected PlotFitAlgorithm alg;

    public PlotFit(XYDataset data, PlotFitAlgorithm alg) {
        this.dataset = data;
        this.alg = alg;
    }

    public void setXYDataset(XYDataset data) {
        this.dataset = data;
    }

    public void setPlotFitAlgorithm(PlotFitAlgorithm alg) {
        this.alg = alg;
    }

    public Object[][][] getResults() {
        this.alg.setXYDataset(this.dataset);
        int arraysize = 0;
        int seriescount = this.dataset.getSeriesCount();
        int i = 0;
        while (i < seriescount) {
            if (this.dataset.getItemCount(i) > arraysize) {
                arraysize = this.dataset.getItemCount(i);
            }
            ++i;
        }
        Object[][][] newdata = new Object[seriescount * 2][arraysize][2];
        int i2 = 0;
        while (i2 < seriescount) {
            int j = 0;
            while (j < this.dataset.getItemCount(i2)) {
                Number x = this.dataset.getXValue(i2, j);
                newdata[i2][j][0] = x;
                newdata[i2][j][1] = this.dataset.getYValue(i2, j);
                Number y = this.alg.getY(i2, x);
                if (y != null) {
                    newdata[i2 + seriescount][j][0] = x;
                    newdata[i2 + seriescount][j][1] = y;
                } else {
                    newdata[i2 + seriescount][j][0] = null;
                    newdata[i2 + seriescount][j][1] = null;
                }
                ++j;
            }
            ++i2;
        }
        return newdata;
    }

    public XYDataset getFit() {
        int seriescount = this.dataset.getSeriesCount();
        String[] seriesnames = new String[seriescount * 2];
        int i = 0;
        while (i < seriescount) {
            seriesnames[i] = this.dataset.getSeriesName(i);
            seriesnames[i + seriescount] = this.dataset.getSeriesName(i) + " " + this.alg.getName();
            ++i;
        }
        return new DefaultXYDataset(seriesnames, this.getResults());
    }
}

