/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class XYStepRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    protected Line2D line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);

    public void drawItem(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, XYPlot plot, ValueAxis horizontalAxis, ValueAxis verticalAxis, XYDataset data, int series, int item, CrosshairInfo crosshairInfo) {
        Paint seriesPaint = plot.getSeriesPaint(series);
        Stroke seriesStroke = plot.getSeriesStroke(series);
        g2.setPaint(seriesPaint);
        g2.setStroke(seriesStroke);
        Number x1 = data.getXValue(series, item);
        Number y1 = data.getYValue(series, item);
        double transX1 = horizontalAxis.translateValueToJava2D(x1.doubleValue(), dataArea);
        double transY1 = verticalAxis.translateValueToJava2D(y1.doubleValue(), dataArea);
        if (item > 0) {
            Number x0 = data.getXValue(series, item - 1);
            Number y0 = data.getYValue(series, item - 1);
            double transX0 = horizontalAxis.translateValueToJava2D(x0.doubleValue(), dataArea);
            double transY0 = verticalAxis.translateValueToJava2D(y0.doubleValue(), dataArea);
            if (transY0 == transY1) {
                this.line.setLine(transX0, transY0, transX1, transY1);
                g2.draw(this.line);
            } else {
                this.line.setLine(transX0, transY0, transX1, transY0);
                g2.draw(this.line);
                this.line.setLine(transX1, transY0, transX1, transY1);
                g2.draw(this.line);
            }
        }
        if (horizontalAxis.isCrosshairLockedOnData()) {
            if (verticalAxis.isCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairPoint(x1.doubleValue(), y1.doubleValue());
            } else {
                crosshairInfo.updateCrosshairX(x1.doubleValue());
            }
        } else if (verticalAxis.isCrosshairLockedOnData()) {
            crosshairInfo.updateCrosshairY(y1.doubleValue());
        }
    }
}

