/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.WindDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class WindItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    public void drawItem(Graphics2D g2, Rectangle2D plotArea, ChartRenderingInfo info, XYPlot plot, ValueAxis horizontalAxis, ValueAxis verticalAxis, XYDataset data, int series, int item, CrosshairInfo crosshairs) {
        WindDataset windData = (WindDataset)data;
        Paint seriesPaint = plot.getSeriesPaint(series);
        Stroke seriesStroke = plot.getSeriesStroke(series);
        g2.setPaint(seriesPaint);
        g2.setStroke(seriesStroke);
        Number x = windData.getXValue(series, item);
        Number windDir = windData.getWindDirection(series, item);
        Number wforce = windData.getWindForce(series, item);
        double windForce = wforce.doubleValue();
        double wdir_t = Math.toRadians(windDir.doubleValue() * -30.0 - 90.0);
        double ax1 = horizontalAxis.translateValueToJava2D(x.doubleValue(), plotArea);
        double ay1 = verticalAxis.translateValueToJava2D(0.0, plotArea);
        double rax2 = x.doubleValue() + windForce * Math.cos(wdir_t) * 8000000.0;
        double ray2 = windForce * Math.sin(wdir_t);
        double ax2 = horizontalAxis.translateValueToJava2D(rax2, plotArea);
        double ay2 = verticalAxis.translateValueToJava2D(ray2, plotArea);
        int diri = windDir.intValue();
        int forcei = wforce.intValue();
        String dirforce = diri + "-" + forcei;
        Line2D.Double line = new Line2D.Double(ax1, ay1, ax2, ay2);
        g2.draw(line);
        g2.setPaint(Color.blue);
        g2.setFont(new Font("foo", 1, 9));
        g2.drawString(dirforce, (float)ax1, (float)ay1);
        g2.setPaint(seriesPaint);
        g2.setStroke(seriesStroke);
        double aldir = Math.toRadians(windDir.doubleValue() * -30.0 - 90.0 - 5.0);
        double ralx2 = wforce.doubleValue() * Math.cos(aldir) * 8000000.0 * 0.8 + x.doubleValue();
        double raly2 = wforce.doubleValue() * Math.sin(aldir) * 0.8;
        double alx2 = horizontalAxis.translateValueToJava2D(ralx2, plotArea);
        double aly2 = verticalAxis.translateValueToJava2D(raly2, plotArea);
        line = new Line2D.Double(alx2, aly2, ax2, ay2);
        g2.draw(line);
        double ardir = Math.toRadians(windDir.doubleValue() * -30.0 - 90.0 + 5.0);
        double rarx2 = wforce.doubleValue() * Math.cos(ardir) * 8000000.0 * 0.8 + x.doubleValue();
        double rary2 = wforce.doubleValue() * Math.sin(ardir) * 0.8;
        double arx2 = horizontalAxis.translateValueToJava2D(rarx2, plotArea);
        double ary2 = verticalAxis.translateValueToJava2D(rary2, plotArea);
        line = new Line2D.Double(arx2, ary2, ax2, ay2);
        g2.draw(line);
    }
}

