/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.event.AxisChangeEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public abstract class WindAxis
extends Axis {
    protected boolean autoRange;
    protected boolean autoTickValue;
    protected int autoTickIndex;
    protected boolean showGridLines;
    protected Stroke gridStroke;
    protected Paint gridPaint;

    public WindAxis(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean showTickLabels, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean showTickMarks, Stroke tickMarkStroke, boolean autoRange, boolean autoTickValue, boolean showGridLines, Stroke gridStroke, Paint gridPaint) {
        super(label, labelFont, labelPaint, labelInsets, showTickLabels, tickLabelFont, tickLabelPaint, tickLabelInsets, showTickMarks, tickMarkStroke);
        this.autoRange = autoRange;
        this.autoTickValue = autoTickValue;
        this.showGridLines = showGridLines;
        this.gridStroke = gridStroke;
        this.gridPaint = gridPaint;
    }

    public WindAxis(String label) {
        super(label);
        this.autoRange = true;
        this.autoTickValue = true;
        this.showGridLines = true;
        this.gridStroke = new BasicStroke(0.25f, 0, 1, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
        this.gridPaint = Color.gray;
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean auto) {
        if (this.autoRange != auto) {
            this.autoRange = auto;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean getAutoTickValue() {
        return this.autoTickValue;
    }

    public void setAutoTickValue(boolean flag) {
        this.autoTickValue = flag;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isShowGridLines() {
        return this.showGridLines;
    }

    public void setShowGridLines(boolean show) {
        this.showGridLines = show;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Stroke getGridStroke() {
        return this.gridStroke;
    }

    public void setGridStroke(Stroke stroke) {
        this.gridStroke = stroke;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getGridPaint() {
        return this.gridPaint;
    }

    public void setGridPaint(Paint paint) {
        this.gridPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected abstract void autoAdjustRange();

    public abstract double translateValueToJava2D(double var1, Rectangle2D var3);
}

