/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.tooltips.StandardXYToolTipGenerator;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;

public class VerticalXYBarRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    protected double margin;
    protected double translatedRangeZero;

    public VerticalXYBarRenderer() {
        this(0.0, new StandardXYToolTipGenerator());
    }

    public VerticalXYBarRenderer(double margin) {
        this(margin, new StandardXYToolTipGenerator());
    }

    public VerticalXYBarRenderer(double margin, XYToolTipGenerator toolTipGenerator) {
        super(toolTipGenerator);
        this.margin = margin;
    }

    public void setMargin(double margin) {
        Double old = new Double(this.margin);
        this.margin = margin;
        this.firePropertyChanged("VerticalXYBarRenderer.margin", old, new Double(margin));
    }

    public void initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, ChartRenderingInfo info) {
        super.initialise(g2, dataArea, plot, data, info);
        ValueAxis rangeAxis = plot.getRangeAxis();
        this.translatedRangeZero = rangeAxis.translateValueToJava2D(0.0, dataArea);
    }

    public void drawItem(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset data, int series, int item, CrosshairInfo crosshairInfo) {
        EntityCollection entities;
        IntervalXYDataset intervalData = (IntervalXYDataset)data;
        Paint seriesPaint = plot.getSeriesPaint(series);
        Paint seriesOutlinePaint = plot.getSeriesOutlinePaint(series);
        Number valueNumber = intervalData.getYValue(series, item);
        double translatedValue = rangeAxis.translateValueToJava2D(valueNumber.doubleValue(), dataArea);
        Number startXNumber = intervalData.getStartXValue(series, item);
        double translatedStartX = domainAxis.translateValueToJava2D(startXNumber.doubleValue(), dataArea);
        Number endXNumber = intervalData.getEndXValue(series, item);
        double translatedEndX = domainAxis.translateValueToJava2D(endXNumber.doubleValue(), dataArea);
        double translatedWidth = Math.max(1.0, translatedEndX - translatedStartX);
        double translatedHeight = Math.abs(translatedValue - this.translatedRangeZero);
        if (this.margin > 0.0) {
            double cut = translatedWidth * this.margin;
            translatedWidth -= cut;
            translatedStartX += cut / 2.0;
        }
        Rectangle2D.Double bar = new Rectangle2D.Double(translatedStartX, Math.min(this.translatedRangeZero, translatedValue), translatedWidth, translatedHeight);
        g2.setPaint(seriesPaint);
        g2.fill(bar);
        if (translatedEndX - translatedStartX > 3.0) {
            g2.setStroke(plot.getSeriesOutlineStroke(series));
            g2.setPaint(seriesOutlinePaint);
            g2.draw(bar);
        }
        if (info != null && (entities = info.getEntityCollection()) != null) {
            String tip = "";
            if (this.toolTipGenerator != null) {
                tip = this.toolTipGenerator.generateToolTip(data, series, item);
            }
            XYItemEntity entity = new XYItemEntity(bar, tip, series, item);
            entities.addEntity(entity);
        }
    }
}

