/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.SymbolicTickUnit;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.Range;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class VerticalSymbolicAxis
extends VerticalNumberAxis
implements VerticalAxis {
    public static final Paint DEFAULT_SYMBOLIC_GRID_LINE_PAINT = new Color(232, 234, 232);
    protected List symbolicValue;
    protected boolean ySymbolicZoomIsAccepted = false;
    public List symbolicGridLineList = null;
    protected Paint symbolicGridPaint;
    protected boolean symbolicGridLinesVisible;

    public VerticalSymbolicAxis(String label, String[] sv) {
        this(label, sv, AxisConstants.DEFAULT_AXIS_LABEL_FONT, true, DEFAULT_SYMBOLIC_GRID_LINE_PAINT);
        this.autoRange = true;
    }

    public VerticalSymbolicAxis(String label, String[] sv, Font labelFont, boolean symbolicGridLinesVisible, Paint symbolicGridPaint) {
        this(label, sv, labelFont, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, false, false, NumberAxis.DEFAULT_MINIMUM_AUTO_RANGE, 0.0, 1.0, false, false, new SymbolicTickUnit(NumberAxis.DEFAULT_TICK_UNIT.getSize(), sv), false, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT, symbolicGridLinesVisible, symbolicGridPaint);
    }

    public VerticalSymbolicAxis(String label, String[] sv, Font labelFont, Paint labelPaint, Insets labelInsets, boolean labelDrawnVertical, boolean tickLabelsVisible, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean tickMarksVisible, Stroke tickMarkStroke, boolean autoRange, boolean autoRangeIncludesZero, boolean autoRangeStickyZero, Number autoRangeMinimum, double minimumAxisValue, double maximumAxisValue, boolean inverted, boolean autoTickUnitSelection, NumberTickUnit tickUnit, boolean gridLinesVisible, Stroke gridStroke, Paint gridPaint, boolean crosshairVisible, double crosshairValue, Stroke crosshairStroke, Paint crosshairPaint, boolean symbolicGridLinesVisible, Paint symbolicGridPaint) {
        super(label, labelFont, labelPaint, labelInsets, labelDrawnVertical, tickLabelsVisible, tickLabelFont, tickLabelPaint, tickLabelInsets, tickMarksVisible, tickMarkStroke, autoRange, autoRangeIncludesZero, autoRangeStickyZero, autoRangeMinimum, minimumAxisValue, maximumAxisValue, inverted, autoTickUnitSelection, tickUnit, gridLinesVisible, gridStroke, gridPaint, crosshairVisible, crosshairValue, crosshairStroke, crosshairPaint);
        this.symbolicValue = Arrays.asList(sv);
        this.symbolicGridLinesVisible = symbolicGridLinesVisible;
        this.symbolicGridPaint = symbolicGridPaint;
    }

    public String[] getSymbolicValue() {
        String[] strToReturn = new String[this.symbolicValue.size()];
        strToReturn = this.symbolicValue.toArray(strToReturn);
        return strToReturn;
    }

    public Paint getSymbolicGridPaint() {
        return this.symbolicGridPaint;
    }

    public boolean isGridLinesVisible() {
        return this.symbolicGridLinesVisible;
    }

    public void setSymbolicGridLinesVisible(boolean flag) {
        if (this.symbolicGridLinesVisible != flag) {
            this.symbolicGridLinesVisible = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public String valueToString(double value) {
        String strToReturn;
        try {
            strToReturn = (String)this.symbolicValue.get((int)value);
        }
        catch (IndexOutOfBoundsException ex) {
            strToReturn = new String("");
        }
        return strToReturn;
    }

    public void setAnchoredRange(double range) {
        if (this.ySymbolicZoomIsAccepted) {
            double anchor = Math.rint(this.anchorValue);
            double min = Math.rint(anchor - range / 2.0) - 0.5;
            double max = Math.rint(anchor + range / 2.0) + 0.5;
            if (min < -0.5) {
                min = -0.5;
            }
            if (max > (double)this.symbolicValue.size() - 0.5) {
                max = (double)this.symbolicValue.size() - 0.5;
            }
            this.setRange(min, max);
        }
    }

    private void selectAutoTickUnit(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        throw new UnsupportedOperationException();
    }

    public void draw(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        super.draw(g2, drawArea, plotArea);
        if (this.symbolicGridLinesVisible) {
            this.drawSymbolicGridLines(g2, drawArea, plotArea);
        }
    }

    public void drawSymbolicGridLines(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        this.drawSymbolicGridLines(g2, drawArea, plotArea, true);
    }

    public void drawSymbolicGridLines(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea, boolean firstGridLineIsDark) {
        this.symbolicGridLineList = new Vector(this.ticks.size());
        boolean currentGridLineIsDark = firstGridLineIsDark;
        double xx = plotArea.getX();
        double outlineStrokeWidth = this.plot.outlineStroke != null ? (double)((BasicStroke)this.plot.outlineStroke).getLineWidth() : 1.0;
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            double yy1 = this.translateValueToJava2D(tick.getNumericalValue() + 0.5, plotArea);
            double yy2 = this.translateValueToJava2D(tick.getNumericalValue() - 0.5, plotArea);
            if (currentGridLineIsDark) {
                g2.setPaint(Color.white);
                g2.setXORMode((Color)this.symbolicGridPaint);
            } else {
                g2.setPaint(Color.white);
                g2.setXORMode(Color.white);
            }
            Rectangle2D.Double symbolicGridLine = new Rectangle2D.Double(xx + outlineStrokeWidth, yy1, plotArea.getMaxX() - xx - outlineStrokeWidth, yy2 - yy1);
            g2.fill(symbolicGridLine);
            this.symbolicGridLineList.add(symbolicGridLine);
            boolean bl = currentGridLineIsDark = !currentGridLineIsDark;
        }
        g2.setPaintMode();
    }

    public Rectangle2D.Double getSymbolicGridLine(int position) {
        if (this.symbolicGridLineList != null) {
            return (Rectangle2D.Double)this.symbolicGridLineList.get(position);
        }
        return null;
    }

    protected void autoAdjustRange() {
        if (this.plot == null) {
            return;
        }
        if (this.plot instanceof VerticalValuePlot) {
            double minRange;
            double lower;
            double upper = this.symbolicValue.size() - 1;
            double range = upper - (lower = 0.0);
            if (range < (minRange = this.autoRangeMinimumSize.doubleValue())) {
                upper = (upper + lower + minRange) / 2.0;
                lower = (upper + lower - minRange) / 2.0;
            }
            double upperMargin = 0.5;
            double lowerMargin = 0.5;
            if (this.autoRangeIncludesZero) {
                if (this.autoRangeStickyZero) {
                    upper = upper <= 0.0 ? 0.0 : (upper += upperMargin);
                    lower = lower >= 0.0 ? 0.0 : (lower -= lowerMargin);
                } else {
                    upper = Math.max(0.0, upper + upperMargin);
                    lower = Math.min(0.0, lower - lowerMargin);
                }
            } else if (this.autoRangeStickyZero) {
                upper = upper <= 0.0 ? Math.min(0.0, upper + upperMargin) : (upper += upperMargin);
                lower = lower >= 0.0 ? Math.max(0.0, lower - lowerMargin) : (lower -= lowerMargin);
            } else {
                upper += upperMargin;
                lower -= lowerMargin;
            }
            this.range = new Range(lower, upper);
        }
    }
}

