/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.data.Range;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class VerticalLogarithmicAxis
extends VerticalNumberAxis {
    public static final double LOG10_VALUE = Math.log(10.0);
    protected final boolean log10TickLabelsFlag;

    public VerticalLogarithmicAxis() {
        this(null);
    }

    public VerticalLogarithmicAxis(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 1.0, 10.0);
    }

    public VerticalLogarithmicAxis(String label, Font labelFont, double minimumAxisValue, double maximumAxisValue) {
        this(label, labelFont, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, true, NumberAxis.DEFAULT_MINIMUM_AUTO_RANGE, minimumAxisValue, maximumAxisValue, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT, true);
    }

    public VerticalLogarithmicAxis(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean labelDrawnVertical, boolean tickLabelsVisible, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean tickMarksVisible, Stroke tickMarkStroke, boolean autoRange, boolean autoRangeIncludesZero, Number autoRangeMinimum, double minimumAxisValue, double maximumAxisValue, boolean inverted, boolean autoTickUnitSelection, NumberTickUnit tickUnit, boolean gridLinesVisible, Stroke gridStroke, Paint gridPaint, boolean crosshairVisible, double crosshairValue, Stroke crosshairStroke, Paint crosshairPaint, boolean log10TickLabelsFlag) {
        super(label, labelFont, labelPaint, labelInsets, labelDrawnVertical, tickLabelsVisible, tickLabelFont, tickLabelPaint, tickLabelInsets, tickMarksVisible, tickMarkStroke, autoRange, autoRangeIncludesZero, false, autoRangeMinimum, minimumAxisValue, maximumAxisValue, inverted, autoTickUnitSelection, tickUnit, gridLinesVisible, gridStroke, gridPaint, crosshairVisible, crosshairValue, crosshairStroke, crosshairPaint);
        this.log10TickLabelsFlag = log10TickLabelsFlag;
    }

    public double translateValueToJava2D(double value, Rectangle2D dataArea) {
        double axisMin = this.adjustedLog10(this.range.getLowerBound());
        double axisMax = this.adjustedLog10(this.range.getUpperBound());
        double maxY = dataArea.getMaxY();
        double minY = dataArea.getMinY();
        value = this.adjustedLog10(value);
        if (this.inverted) {
            return minY + (value - axisMin) / (axisMax - axisMin) * (maxY - minY);
        }
        return maxY - (value - axisMin) / (axisMax - axisMin) * (maxY - minY);
    }

    public double translateJava2DtoValue(float java2DValue, Rectangle2D dataArea) {
        double axisMin = this.adjustedLog10(this.range.getLowerBound());
        double axisMax = this.adjustedLog10(this.range.getUpperBound());
        double plotY = dataArea.getY();
        double plotMaxY = dataArea.getMaxY();
        if (this.inverted) {
            return axisMin + Math.pow(10.0, ((double)java2DValue - plotY) / (plotMaxY - plotY) * (axisMax - axisMin));
        }
        return axisMax - Math.pow(10.0, ((double)java2DValue - plotY) / (plotMaxY - plotY) * (axisMax - axisMin));
    }

    public void autoAdjustRange() {
        if (this.plot == null) {
            return;
        }
        if (this.plot instanceof VerticalValuePlot) {
            double minRange;
            double lower;
            double upper;
            VerticalValuePlot vvp = (VerticalValuePlot)((Object)this.plot);
            Range r = vvp.getVerticalDataRange();
            if (r == null) {
                r = new Range(0.0, 1.0);
            }
            if ((upper = this.computeLogCeil(r.getUpperBound())) - (lower = this.computeLogFloor(r.getLowerBound())) < (minRange = this.autoRangeMinimumSize.doubleValue())) {
                upper = (upper + lower + minRange) / 2.0;
                lower = (upper + lower - minRange) / 2.0;
            }
            this.range = new Range(lower, upper);
        }
    }

    private double computeLogCeil(double upper) {
        double logCeil;
        if (upper > 10.0) {
            logCeil = Math.log(upper) / LOG10_VALUE;
            logCeil = Math.ceil(logCeil);
            logCeil = Math.pow(10.0, logCeil);
        } else if (upper < -10.0) {
            logCeil = Math.log(-upper) / LOG10_VALUE;
            logCeil = Math.ceil(-logCeil);
            logCeil = -Math.pow(10.0, -logCeil);
        } else {
            logCeil = Math.ceil(upper);
        }
        return logCeil;
    }

    private double computeLogFloor(double lower) {
        double logFloor;
        if (lower > 10.0) {
            logFloor = Math.log(lower) / LOG10_VALUE;
            logFloor = Math.floor(logFloor);
            logFloor = Math.pow(10.0, logFloor);
        } else if (lower < -10.0) {
            logFloor = Math.log(-lower) / LOG10_VALUE;
            logFloor = Math.floor(-logFloor);
            logFloor = -Math.pow(10.0, -logFloor);
        } else {
            logFloor = Math.floor(lower);
        }
        return logFloor;
    }

    public void refreshTicks(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        this.ticks.clear();
        int iBegCount = (int)Math.rint(this.adjustedLog10(this.range.getLowerBound()));
        int iEndCount = (int)Math.rint(this.adjustedLog10(this.range.getUpperBound()));
        boolean zeroTickFlag = false;
        int i = iBegCount;
        while (i <= iEndCount) {
            int jEndCount = 10;
            if (i == iEndCount) {
                jEndCount = 1;
            }
            int j = 0;
            while (j < jEndCount) {
                String tickLabel;
                double tickVal;
                if (zeroTickFlag) {
                    --j;
                }
                double d = tickVal = i >= 0 ? Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j : -(Math.pow(10.0, -i) - Math.pow(10.0, -i - 1) * (double)j);
                if (j == 0) {
                    if (!zeroTickFlag) {
                        if (i > iBegCount && i < iEndCount && Math.abs(tickVal - 1.0) < 1.0E-4) {
                            tickVal = 0.0;
                            zeroTickFlag = true;
                            tickLabel = "0";
                        } else {
                            tickLabel = this.log10TickLabelsFlag ? (i < 0 ? "-" : "") + "10^" + Math.abs(i) : Long.toString((long)Math.rint(tickVal));
                        }
                    } else {
                        tickLabel = "";
                        zeroTickFlag = false;
                    }
                } else {
                    tickLabel = "";
                    zeroTickFlag = false;
                }
                Double currentTickValue = new Double(tickVal);
                double yy = this.translateValueToJava2D(tickVal, plotArea);
                Rectangle2D tickLabelBounds = this.tickLabelFont.getStringBounds(tickLabel, g2.getFontRenderContext());
                float x = (float)(plotArea.getX() - tickLabelBounds.getWidth() - (double)this.tickLabelInsets.left - (double)this.tickLabelInsets.right);
                float y = (float)(yy + tickLabelBounds.getHeight() / 3.0);
                this.ticks.add(new Tick(currentTickValue, tickLabel, x, y));
                ++j;
            }
            ++i;
        }
    }

    public double adjustedLog10(double val) {
        boolean negFlag = val < 0.0;
        if (negFlag) {
            val = -val;
        }
        if (val < 10.0) {
            val += (10.0 - val) / 10.0;
        }
        return negFlag ? -(Math.log(val) / LOG10_VALUE) : Math.log(val) / LOG10_VALUE;
    }
}

