/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.BarRenderer;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.IntervalCategoryDataset;
import com.jrefinery.data.Range;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;

public class VerticalIntervalBarRenderer
extends BarRenderer
implements CategoryItemRenderer {
    private static final int LOW_LABEL = 0;
    private static final int HIGH_LABEL = 1;

    public VerticalIntervalBarRenderer() {
        this(new StandardCategoryToolTipGenerator());
    }

    public VerticalIntervalBarRenderer(CategoryToolTipGenerator toolTipGenerator) {
        super(toolTipGenerator);
    }

    public void initialise(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, ChartRenderingInfo info) {
        super.initialise(g2, dataArea, plot, axis, data, info);
        this.calculateCategoryAndItemSpans(g2, dataArea, plot, data, dataArea.getWidth());
    }

    public void drawRangeMarker(Graphics2D g2, CategoryPlot plot, ValueAxis axis, Marker marker, Rectangle2D axisDataArea, Shape dataClipRegion) {
        double value = marker.getValue();
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        double y = axis.translateValueToJava2D(marker.getValue(), axisDataArea);
        Line2D.Double line = new Line2D.Double(axisDataArea.getMinX(), y, axisDataArea.getMaxX(), y);
        g2.setPaint(marker.getOutlinePaint());
        g2.draw(line);
    }

    public void drawCategoryItem(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, int series, Object category, int categoryIndex, Object previousCategory) {
        IntervalCategoryDataset intervalData = (IntervalCategoryDataset)data;
        double rectX = dataArea.getX() + dataArea.getWidth() * plot.getIntroGapPercent();
        int categories = data.getCategoryCount();
        int seriesCount = data.getSeriesCount();
        if (categories > 1) {
            rectX = rectX + (double)categoryIndex * (this.categorySpan / (double)categories) + ((double)categoryIndex * (this.categoryGapSpan / (double)(categories - 1)) + (double)series * this.itemSpan / (double)(categories * seriesCount));
            if (seriesCount > 1) {
                rectX += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
            }
        } else {
            rectX += (double)series * this.itemSpan / (double)(categories * seriesCount);
            if (seriesCount > 1) {
                rectX += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
            }
        }
        Number value0 = intervalData.getEndValue(series, category);
        double translatedValue0 = axis.translateValueToJava2D(value0.doubleValue(), dataArea);
        Number value1 = intervalData.getStartValue(series, category);
        double translatedValue1 = axis.translateValueToJava2D(value1.doubleValue(), dataArea);
        if (translatedValue1 < translatedValue0) {
            double temp = translatedValue1;
            translatedValue1 = translatedValue0;
            translatedValue0 = temp;
            Number tempNum = value1;
            value1 = value0;
            value0 = tempNum;
        }
        double rectY = translatedValue0;
        double rectWidth = this.itemWidth;
        double rectHeight = Math.abs(translatedValue1 - translatedValue0);
        Rectangle2D.Double bar = new Rectangle2D.Double(rectX, rectY, rectWidth, rectHeight);
        Paint seriesPaint = plot.getSeriesPaint(series);
        g2.setPaint(seriesPaint);
        g2.fill(bar);
        if (this.itemWidth > 3.0) {
            g2.setStroke(plot.getSeriesStroke(series));
            g2.setPaint(plot.getSeriesOutlinePaint(series));
            g2.draw(bar);
        }
        if (plot.getLabelsVisible()) {
            NumberFormat formatter = plot.getLabelFormatter();
            Font labelFont = plot.getLabelFont();
            g2.setFont(labelFont);
            Paint paint = plot.getLabelPaint();
            g2.setPaint(paint);
            boolean rotate = plot.getVerticalLabels();
            String lowLabel = formatter.format(value1);
            Rectangle2D.Double lowLabelArea = new Rectangle2D.Double(rectX, translatedValue1, rectWidth, dataArea.getMaxY() - translatedValue1);
            this.drawLabel(g2, lowLabel, lowLabelArea, labelFont, 0, rotate);
            String highLabel = formatter.format(value0);
            Rectangle2D.Double highLabelArea = new Rectangle2D.Double(rectX, dataArea.getY(), rectWidth, translatedValue0 - dataArea.getY());
            this.drawLabel(g2, highLabel, highLabelArea, labelFont, 1, rotate);
        }
    }

    private void drawLabel(Graphics2D g2, String label, Rectangle2D labelArea, Font labelFont, int labelType, boolean rotate) {
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D labelBounds = labelFont.getStringBounds(label, frc);
        LineMetrics lm = labelFont.getLineMetrics(label, frc);
        float labelx = (float)labelArea.getCenterX();
        if (rotate) {
            float labely = labelType == 1 ? (float)(labelArea.getMaxY() - (double)lm.getLeading()) : (float)(labelArea.getY() + labelBounds.getWidth() + (double)lm.getLeading());
            RefineryUtilities.drawRotatedString(label, g2, labelx += (float)(labelBounds.getHeight() / 2.0 - (double)lm.getDescent()), labely, -1.5707963267948966);
        } else {
            float labely = labelType == 1 ? (float)(labelArea.getMaxY() - (double)lm.getDescent() - (double)lm.getLeading()) : (float)(labelArea.getY() + (double)lm.getAscent() + (double)lm.getLeading());
            g2.drawString(label, labelx -= (float)(labelBounds.getWidth() / 2.0), labely);
        }
    }

    public boolean hasItemGaps() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset data) {
        return data.getSeriesCount();
    }

    static {
        LOW_LABEL = 0;
        HIGH_LABEL = 1;
    }
}

