/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.HorizontalCategoryPlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class VerticalCategoryAxis
extends CategoryAxis
implements VerticalAxis {
    public static final boolean DEFAULT_VERTICAL_LABEL = true;
    protected boolean verticalLabel;

    public VerticalCategoryAxis(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, AxisConstants.DEFAULT_TICK_STROKE);
    }

    public VerticalCategoryAxis(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean verticalLabel, boolean categoryLabelsVisible, Font categoryLabelFont, Paint categoryLabelPaint, Insets categoryLabelInsets, boolean tickMarksVisible, Stroke tickMarkStroke) {
        super(label, labelFont, labelPaint, labelInsets, categoryLabelsVisible, categoryLabelFont, categoryLabelPaint, categoryLabelInsets, tickMarksVisible, tickMarkStroke);
        this.verticalLabel = verticalLabel;
    }

    public boolean isVerticalLabel() {
        return this.verticalLabel;
    }

    public void setVerticalLabel(boolean flag) {
        if (this.verticalLabel != flag) {
            this.verticalLabel = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void draw(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        if (!this.visible) {
            return;
        }
        if (this.label != null) {
            double yy;
            double xx;
            g2.setFont(this.labelFont);
            g2.setPaint(this.labelPaint);
            FontRenderContext frc = g2.getFontRenderContext();
            LineMetrics metrics = this.labelFont.getLineMetrics(this.label, frc);
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, frc);
            if (this.verticalLabel) {
                xx = drawArea.getX() + (double)this.labelInsets.left + (double)metrics.getHeight() - (double)metrics.getDescent() - (double)metrics.getLeading();
                yy = plotArea.getY() + plotArea.getHeight() / 2.0 + labelBounds.getWidth() / 2.0;
                RefineryUtilities.drawRotatedString(this.label, g2, (float)xx, (float)yy, -1.5707963267948966);
            } else {
                xx = drawArea.getX() + (double)this.labelInsets.left;
                yy = drawArea.getY() + drawArea.getHeight() / 2.0 - labelBounds.getHeight() / 2.0;
                g2.drawString(this.label, (float)xx, (float)yy);
            }
        }
        if (this.tickLabelsVisible) {
            g2.setFont(this.tickLabelFont);
            g2.setPaint(this.tickLabelPaint);
            this.refreshTicks(g2, drawArea, plotArea);
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                g2.drawString(tick.getText(), tick.getX(), tick.getY());
            }
        }
    }

    public void refreshTicks(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        this.ticks.clear();
        CategoryPlot categoryPlot = (CategoryPlot)this.plot;
        CategoryDataset data = categoryPlot.getCategoryDataset();
        if (data != null) {
            Font font = this.getTickLabelFont();
            g2.setFont(font);
            FontRenderContext frc = g2.getFontRenderContext();
            int categoryIndex = 0;
            Iterator iterator = data.getCategories().iterator();
            while (iterator.hasNext()) {
                Object category = iterator.next();
                String label = category.toString();
                Rectangle2D labelBounds = font.getStringBounds(label, frc);
                LineMetrics metrics = font.getLineMetrics(label, frc);
                float xx = (float)(plotArea.getX() - (double)this.tickLabelInsets.right - labelBounds.getWidth());
                float yy = (float)(categoryPlot.getCategoryCoordinate(categoryIndex, plotArea) - (double)metrics.getStrikethroughOffset() + 0.5);
                Tick tick = new Tick(category, label, xx, yy);
                this.ticks.add(tick);
                ++categoryIndex;
            }
        }
    }

    public double reserveWidth(Graphics2D g2, Plot plot, Rectangle2D drawArea) {
        if (!this.visible) {
            return 0.0;
        }
        double labelWidth = 0.0;
        if (this.label != null) {
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, g2.getFontRenderContext());
            labelWidth = this.labelInsets.left + this.labelInsets.right;
            labelWidth = this.verticalLabel ? (labelWidth += labelBounds.getHeight()) : (labelWidth += labelBounds.getWidth());
        }
        double tickLabelWidth = this.tickLabelInsets.left + this.tickLabelInsets.right;
        if (this.tickLabelsVisible) {
            this.refreshTicks(g2, drawArea, drawArea);
            tickLabelWidth += this.getMaxTickLabelWidth(g2, drawArea);
        }
        return labelWidth + tickLabelWidth;
    }

    public Rectangle2D reserveAxisArea(Graphics2D g2, Plot plot, Rectangle2D drawArea, double reservedHeight) {
        if (!this.visible) {
            return new Rectangle2D.Double(drawArea.getX(), drawArea.getY(), 0.0, drawArea.getHeight() - reservedHeight);
        }
        double labelWidth = 0.0;
        if (this.label != null) {
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, g2.getFontRenderContext());
            labelWidth = this.labelInsets.left + this.labelInsets.right;
            labelWidth = this.verticalLabel ? (labelWidth += labelBounds.getHeight()) : (labelWidth += labelBounds.getWidth());
        }
        double tickLabelWidth = this.tickLabelInsets.left + this.tickLabelInsets.right;
        if (this.tickLabelsVisible) {
            this.refreshTicks(g2, drawArea, drawArea);
            tickLabelWidth += this.getMaxTickLabelWidth(g2, drawArea);
        }
        return new Rectangle2D.Double(drawArea.getX(), drawArea.getY(), labelWidth + tickLabelWidth, drawArea.getHeight() - reservedHeight);
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof HorizontalCategoryPlot;
    }

    public void configure() {
    }

    static {
        DEFAULT_VERTICAL_LABEL = true;
    }
}

