/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalBarRenderer;
import com.jrefinery.chart.VerticalNumberAxis3D;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class VerticalBarRenderer3D
extends VerticalBarRenderer {
    private static final double DEFAULT_EFFECT3D = 10.0;
    protected double effect3d;

    public VerticalBarRenderer3D() {
        this(new StandardCategoryToolTipGenerator(), 10.0);
    }

    public VerticalBarRenderer3D(CategoryToolTipGenerator toolTipGenerator, double effect3d) {
        super(toolTipGenerator);
        this.effect3d = effect3d;
    }

    public boolean hasItemGaps() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset data) {
        return data.getSeriesCount();
    }

    public Rectangle2D getAxisArea(Rectangle2D dataArea) {
        return new Rectangle2D.Double(dataArea.getX(), dataArea.getY() + this.effect3d, dataArea.getWidth() - this.effect3d, dataArea.getHeight() - this.effect3d);
    }

    public Shape getDataClipRegion(Rectangle2D dataArea) {
        GeneralPath result = new GeneralPath();
        result.moveTo((float)dataArea.getX(), (float)(dataArea.getMinY() + this.effect3d));
        result.lineTo((float)(dataArea.getX() + this.effect3d), (float)dataArea.getMinY());
        result.lineTo((float)dataArea.getMaxX(), (float)dataArea.getMinY());
        result.lineTo((float)dataArea.getMaxX(), (float)(dataArea.getMaxY() - this.effect3d));
        result.lineTo((float)(dataArea.getMaxX() - this.effect3d), (float)dataArea.getMaxY());
        result.lineTo((float)dataArea.getX(), (float)dataArea.getMaxY());
        result.closePath();
        return result;
    }

    public void drawPlotBackground(Graphics2D g2, CategoryPlot plot, Rectangle2D axisDataArea, Shape dataClipRegion) {
        super.drawPlotBackground(g2, plot, axisDataArea, dataClipRegion);
        double x1 = axisDataArea.getX();
        double x2 = x1 + this.effect3d;
        double x3 = axisDataArea.getMaxX() + this.effect3d;
        double y1 = axisDataArea.getMaxY();
        double y2 = y1 - this.effect3d;
        double y3 = axisDataArea.getMinY() - this.effect3d;
        g2.setPaint(plot.getOutlinePaint());
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        g2.draw(line);
        ((Line2D)line).setLine(x2, y2, x2, y3);
        g2.draw(line);
        ((Line2D)line).setLine(x2, y2, x3, y2);
        g2.draw(line);
    }

    public void drawRangeMarker(Graphics2D g2, CategoryPlot plot, ValueAxis axis, Marker marker, Rectangle2D axisDataArea, Shape dataClipRegion) {
        double value = marker.getValue();
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        float y = (float)axis.translateValueToJava2D(marker.getValue(), axisDataArea);
        float x = (float)axisDataArea.getX();
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y);
        path.lineTo(x + (float)this.effect3d, y - (float)this.effect3d);
        path.lineTo((float)(axisDataArea.getMaxX() + this.effect3d), y - (float)this.effect3d);
        path.lineTo((float)axisDataArea.getMaxX(), y);
        path.closePath();
        g2.setPaint(marker.getPaint());
        g2.fill(path);
        g2.setPaint(marker.getOutlinePaint());
        g2.draw(path);
    }

    public void drawCategoryItem(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, int series, Object category, int categoryIndex, Object previousCategory) {
        Number value = data.getValue(series, category);
        if (value != null) {
            EntityCollection entities;
            double rectX = dataArea.getX() + dataArea.getWidth() * plot.getIntroGapPercent();
            int categories = data.getCategoryCount();
            int seriesCount = data.getSeriesCount();
            if (categories > 1) {
                rectX = rectX + (double)categoryIndex * (this.categorySpan / (double)categories) + ((double)categoryIndex * (this.categoryGapSpan / (double)(categories - 1)) + (double)series * this.itemSpan / (double)(categories * seriesCount));
                if (seriesCount > 1) {
                    rectX += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
                }
            } else {
                rectX += (double)series * this.itemSpan / (double)(categories * seriesCount);
                if (seriesCount > 1) {
                    rectX += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
                }
            }
            double y = value.doubleValue();
            double base = 0.0;
            if (this.upperClip <= 0.0) {
                if (y >= this.upperClip) {
                    return;
                }
                base = this.upperClip;
                if (y <= this.lowerClip) {
                    y = this.lowerClip;
                }
            } else if (this.lowerClip <= 0.0) {
                if (y >= this.upperClip) {
                    y = this.upperClip;
                } else if (y <= this.lowerClip) {
                    y = this.lowerClip;
                }
            } else {
                if (y <= this.lowerClip) {
                    return;
                }
                base = this.lowerClip;
                if (y >= this.upperClip) {
                    y = this.upperClip;
                }
            }
            double transY1 = axis.translateValueToJava2D(base, dataArea);
            double transY2 = axis.translateValueToJava2D(y, dataArea);
            double rectY = Math.min(transY1, transY2);
            double rectWidth = this.itemWidth;
            double rectHeight = Math.abs(transY1 - transY2);
            Rectangle2D.Double bar = new Rectangle2D.Double(rectX, rectY, rectWidth, rectHeight);
            Paint seriesPaint = plot.getSeriesPaint(series);
            g2.setPaint(seriesPaint);
            g2.fill(bar);
            GeneralPath bar3dRight = null;
            GeneralPath bar3dTop = null;
            double effect3d = 0.0;
            VerticalAxis vAxis = (VerticalAxis)((Object)plot.getRangeAxis());
            if (rectHeight != 0.0 && vAxis instanceof VerticalNumberAxis3D) {
                effect3d = ((VerticalNumberAxis3D)vAxis).getEffect3d();
                bar3dRight = new GeneralPath();
                bar3dRight.moveTo((float)(rectX + rectWidth), (float)rectY);
                bar3dRight.lineTo((float)(rectX + rectWidth), (float)(rectY + rectHeight));
                bar3dRight.lineTo((float)(rectX + rectWidth + effect3d), (float)(rectY + rectHeight - effect3d));
                bar3dRight.lineTo((float)(rectX + rectWidth + effect3d), (float)(rectY - effect3d));
                if (seriesPaint instanceof Color) {
                    g2.setPaint(((Color)seriesPaint).darker());
                }
                g2.fill(bar3dRight);
                bar3dTop = new GeneralPath();
                bar3dTop.moveTo((float)rectX, (float)rectY);
                bar3dTop.lineTo((float)(rectX + effect3d), (float)(rectY - effect3d));
                bar3dTop.lineTo((float)(rectX + rectWidth + effect3d), (float)(rectY - effect3d));
                bar3dTop.lineTo((float)(rectX + rectWidth), (float)rectY);
                if (seriesPaint instanceof Color) {
                    g2.setPaint((Color)seriesPaint);
                }
                g2.fill(bar3dTop);
            }
            if (this.itemWidth > 3.0) {
                g2.setStroke(plot.getSeriesOutlineStroke(series));
                g2.setPaint(plot.getSeriesOutlinePaint(series));
                g2.draw(bar);
                if (bar3dRight != null) {
                    g2.draw(bar3dRight);
                }
                if (bar3dTop != null) {
                    g2.draw(bar3dTop);
                }
                if (plot.getLabelsVisible()) {
                    Font labelFont = plot.getLabelFont();
                    g2.setFont(labelFont);
                    Paint paint = plot.getLabelPaint();
                    g2.setPaint(paint);
                    g2.drawString(String.valueOf(value), (int)rectX, (int)rectY - 15);
                }
            }
            if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
                String tip = "";
                if (this.toolTipGenerator != null) {
                    tip = this.toolTipGenerator.generateToolTip(data, series, category);
                }
                CategoryItemEntity entity = new CategoryItemEntity(bar, tip, series, category, categoryIndex);
                entities.addEntity(entity);
            }
        }
    }

    static {
        DEFAULT_EFFECT3D = 10.0;
    }
}

