/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.Range;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public abstract class ValueAxis
extends Axis {
    public static final boolean DEFAULT_AUTO_RANGE = true;
    public static final double DEFAULT_MINIMUM_AXIS_VALUE = 0.0;
    public static final double DEFAULT_MAXIMUM_AXIS_VALUE = 1.0;
    public static final Stroke DEFAULT_GRID_LINE_STROKE;
    public static final Paint DEFAULT_GRID_LINE_PAINT;
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Stroke DEFAULT_CROSSHAIR_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT;
    protected boolean autoRange;
    protected double minimumRangeLength;
    protected double maximumRangeLength;
    protected double fixedAutoRange;
    protected Range range;
    protected boolean autoTickUnitSelection;
    protected int autoTickIndex;
    protected boolean gridLinesVisible;
    protected Stroke gridStroke;
    protected Paint gridPaint;
    protected double anchorValue;
    protected boolean crosshairVisible;
    protected double crosshairValue;
    protected Stroke crosshairStroke;
    protected Paint crosshairPaint;
    protected boolean crosshairLockedOnData = true;

    protected ValueAxis(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, true, true, DEFAULT_GRID_LINE_STROKE, DEFAULT_GRID_LINE_PAINT, false, 0.0, DEFAULT_CROSSHAIR_STROKE, DEFAULT_CROSSHAIR_PAINT);
    }

    protected ValueAxis(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean tickLabelsVisible, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean tickMarksVisible, Stroke tickMarkStroke, boolean autoRange, boolean autoTickUnitSelection, boolean gridLinesVisible, Stroke gridStroke, Paint gridPaint, boolean crosshairVisible, double crosshairValue, Stroke crosshairStroke, Paint crosshairPaint) {
        super(label, labelFont, labelPaint, labelInsets, tickLabelsVisible, tickLabelFont, tickLabelPaint, tickLabelInsets, tickMarksVisible, tickMarkStroke);
        this.autoRange = autoRange;
        this.fixedAutoRange = 0.0;
        this.minimumRangeLength = Double.MIN_VALUE;
        this.maximumRangeLength = Double.MAX_VALUE;
        this.autoTickUnitSelection = autoTickUnitSelection;
        this.gridLinesVisible = gridLinesVisible;
        this.gridStroke = gridStroke;
        this.gridPaint = gridPaint;
        this.crosshairValue = crosshairValue;
        this.crosshairStroke = crosshairStroke;
        this.crosshairPaint = crosshairPaint;
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean auto) {
        if (this.autoRange != auto) {
            this.autoRange = auto;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public double getFixedAutoRange() {
        return this.fixedAutoRange;
    }

    public void setFixedAutoRange(double range) {
        this.fixedAutoRange = range;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getMinimumAxisValue() {
        return this.range.getLowerBound();
    }

    public void setMinimumAxisValue(double min) {
        this.setRange(new Range(min, this.range.getUpperBound()));
    }

    public double getMaximumAxisValue() {
        return this.range.getUpperBound();
    }

    public void setMaximumAxisValue(double max) {
        this.setRange(new Range(this.range.getLowerBound(), max));
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("ValueAxis.setAxisRange(...): null not permitted.");
        }
        this.autoRange = false;
        this.range = range;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void setRange(double lower, double upper) {
        this.setRange(new Range(lower, upper));
    }

    public void setRangeAboutValue(double value, double size) {
        this.setRange(new Range(value - size / 2.0, value + size / 2.0));
    }

    public boolean isAutoTickUnitSelection() {
        return this.autoTickUnitSelection;
    }

    public void setAutoTickUnitSelection(boolean flag) {
        if (this.autoTickUnitSelection != flag) {
            this.autoTickUnitSelection = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isGridLinesVisible() {
        return this.gridLinesVisible;
    }

    public void setGridLinesVisible(boolean flag) {
        if (this.gridLinesVisible != flag) {
            this.gridLinesVisible = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Stroke getGridStroke() {
        return this.gridStroke;
    }

    public void setGridStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("ValueAxis.setGridStroke(...): null not permitted");
        }
        this.gridStroke = stroke;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getGridPaint() {
        return this.gridPaint;
    }

    public void setGridPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("ValueAxis.setGridPaint(...): null not permitted");
        }
        this.gridPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getAnchorValue() {
        return this.anchorValue;
    }

    public void setAnchorValue(double value) {
        this.anchorValue = value;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isCrosshairVisible() {
        return this.crosshairVisible;
    }

    public void setCrosshairVisible(boolean flag) {
        if (this.crosshairVisible != flag) {
            this.crosshairVisible = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isCrosshairLockedOnData() {
        return this.crosshairLockedOnData;
    }

    public void setCrosshairLockedOnData(boolean flag) {
        if (this.crosshairLockedOnData != flag) {
            this.crosshairLockedOnData = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public double getCrosshairValue() {
        return this.crosshairValue;
    }

    public void setCrosshairValue(double value) {
        this.crosshairValue = value;
        if (this.isCrosshairVisible()) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Stroke getCrosshairStroke() {
        return this.crosshairStroke;
    }

    public void setCrosshairStroke(Stroke stroke) {
        this.crosshairStroke = stroke;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getCrosshairPaint() {
        return this.crosshairPaint;
    }

    public void setCrosshairPaint(Paint paint) {
        this.crosshairPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public abstract double translateValueToJava2D(double var1, Rectangle2D var3);

    public abstract double translateJava2DtoValue(float var1, Rectangle2D var2);

    protected abstract void autoAdjustRange();

    public void setAnchoredRange(double range) {
        double min = this.anchorValue - range / 2.0;
        double max = this.anchorValue + range / 2.0;
        this.setRange(new Range(min, max));
    }

    public void centerRange(double value) {
        double central = this.range.getCentralValue();
        Range adjusted = new Range(this.range.getLowerBound() + value - central, this.range.getUpperBound() + value - central);
        this.setRange(adjusted);
    }

    public void resizeRange(double percent) {
        this.resizeRange(percent, this.range.getCentralValue());
    }

    public void resizeRange(double percent, double anchorValue) {
        double halfLength = this.range.getLength() * percent / 2.0;
        Range adjusted = new Range(anchorValue - halfLength, anchorValue + halfLength);
        this.setRange(adjusted);
    }

    static {
        DEFAULT_AUTO_RANGE = true;
        DEFAULT_MINIMUM_AXIS_VALUE = 0.0;
        DEFAULT_MAXIMUM_AXIS_VALUE = 1.0;
        DEFAULT_GRID_LINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
        DEFAULT_GRID_LINE_PAINT = Color.gray;
        DEFAULT_CROSSHAIR_VISIBLE = false;
        DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRID_LINE_STROKE;
        DEFAULT_CROSSHAIR_PAINT = Color.blue;
    }
}

