/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.TickUnit;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TickUnits {
    protected List units = new ArrayList();

    public void add(TickUnit unit) {
        this.units.add(unit);
        Collections.sort(this.units);
    }

    public TickUnit getLargerTickUnit(TickUnit unit) {
        int index = Collections.binarySearch(this.units, unit);
        index = index >= 0 ? ++index : -index;
        return (TickUnit)this.units.get(Math.min(index, this.units.size() - 1));
    }

    public TickUnit getCeilingTickUnit(TickUnit unit) {
        int index = Collections.binarySearch(this.units, unit);
        if (index >= 0) {
            return (TickUnit)this.units.get(index);
        }
        index = -(index + 1);
        return (TickUnit)this.units.get(Math.min(index, this.units.size() - 1));
    }

    public TickUnit getCeilingTickUnit(double size) {
        return this.getCeilingTickUnit(new NumberTickUnit(size, null));
    }

    public static TickUnits createStandardTickUnits() {
        TickUnits units = new TickUnits();
        units.add(new NumberTickUnit(1.0E-7, new DecimalFormat("0.0000000")));
        units.add(new NumberTickUnit(1.0E-6, new DecimalFormat("0.000000")));
        units.add(new NumberTickUnit(1.0E-5, new DecimalFormat("0.00000")));
        units.add(new NumberTickUnit(1.0E-4, new DecimalFormat("0.0000")));
        units.add(new NumberTickUnit(0.001, new DecimalFormat("0.000")));
        units.add(new NumberTickUnit(0.01, new DecimalFormat("0.00")));
        units.add(new NumberTickUnit(0.1, new DecimalFormat("0.0")));
        units.add(new NumberTickUnit(1.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(10.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(100.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(1000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(10000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(100000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(1000000.0, new DecimalFormat("#,###,##0")));
        units.add(new NumberTickUnit(1.0E7, new DecimalFormat("#,###,##0")));
        units.add(new NumberTickUnit(1.0E8, new DecimalFormat("#,###,##0")));
        units.add(new NumberTickUnit(1.0E9, new DecimalFormat("#,###,###,##0")));
        units.add(new NumberTickUnit(2.5E-7, new DecimalFormat("0.00000000")));
        units.add(new NumberTickUnit(2.5E-6, new DecimalFormat("0.0000000")));
        units.add(new NumberTickUnit(2.5E-5, new DecimalFormat("0.000000")));
        units.add(new NumberTickUnit(2.5E-4, new DecimalFormat("0.00000")));
        units.add(new NumberTickUnit(0.0025, new DecimalFormat("0.0000")));
        units.add(new NumberTickUnit(0.025, new DecimalFormat("0.000")));
        units.add(new NumberTickUnit(0.25, new DecimalFormat("0.00")));
        units.add(new NumberTickUnit(2.5, new DecimalFormat("0.0")));
        units.add(new NumberTickUnit(25.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(250.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(2500.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(25000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(250000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(2500000.0, new DecimalFormat("#,###,##0")));
        units.add(new NumberTickUnit(2.5E7, new DecimalFormat("#,###,##0")));
        units.add(new NumberTickUnit(2.5E8, new DecimalFormat("#,###,##0")));
        units.add(new NumberTickUnit(2.5E9, new DecimalFormat("#,###,###,##0")));
        units.add(new NumberTickUnit(5.0E-7, new DecimalFormat("0.0000000")));
        units.add(new NumberTickUnit(5.0E-6, new DecimalFormat("0.000000")));
        units.add(new NumberTickUnit(5.0E-5, new DecimalFormat("0.00000")));
        units.add(new NumberTickUnit(5.0E-4, new DecimalFormat("0.0000")));
        units.add(new NumberTickUnit(0.005, new DecimalFormat("0.000")));
        units.add(new NumberTickUnit(0.05, new DecimalFormat("0.00")));
        units.add(new NumberTickUnit(0.5, new DecimalFormat("0.0")));
        units.add(new NumberTickUnit(5.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(50.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(500.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(5000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(50000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(500000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(5000000.0, new DecimalFormat("#,###,##0")));
        units.add(new NumberTickUnit(5.0E7, new DecimalFormat("#,###,##0")));
        units.add(new NumberTickUnit(5.0E8, new DecimalFormat("#,###,##0")));
        units.add(new NumberTickUnit(5.0E9, new DecimalFormat("#,###,###,##0")));
        return units;
    }

    public static TickUnits createIntegerTickUnits() {
        TickUnits units = new TickUnits();
        units.add(new NumberTickUnit(1.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(2.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(5.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(10.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(20.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(50.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(100.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(200.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(500.0, new DecimalFormat("0")));
        units.add(new NumberTickUnit(1000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(2000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(5000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(10000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(20000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(50000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(100000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(200000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(500000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(1000000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(2000000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(5000000.0, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(1.0E7, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(2.0E7, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(5.0E7, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(1.0E8, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(2.0E8, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(5.0E8, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(1.0E9, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(2.0E9, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(5.0E9, new DecimalFormat("#,##0")));
        units.add(new NumberTickUnit(1.0E10, new DecimalFormat("#,##0")));
        return units;
    }
}

