/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.event.TitleChangeEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;

public class TextTitle
extends AbstractTitle {
    public static final Font DEFAULT_FONT = new Font("Dialog", 1, 12);
    public static final Paint DEFAULT_TEXT_PAINT = Color.black;
    protected String text;
    protected Font font;
    protected Paint paint;

    public TextTitle(String text) {
        this(text, DEFAULT_FONT, DEFAULT_TEXT_PAINT, 0, 4, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public TextTitle(String text, Font font) {
        this(text, font, DEFAULT_TEXT_PAINT, 0, 4, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public TextTitle(String text, Font font, Paint paint) {
        this(text, font, paint, 0, 4, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public TextTitle(String text, Font font, int horizontalAlignment) {
        this(text, font, DEFAULT_TEXT_PAINT, 0, horizontalAlignment, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public TextTitle(String text, Font font, Paint paint, int position, int horizontalAlignment, int verticalAlignment, Spacer spacer) {
        super(position, horizontalAlignment, verticalAlignment, spacer);
        this.text = text;
        this.font = font;
        this.paint = paint;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (!this.font.equals(font)) {
            this.font = font;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (!this.paint.equals(paint)) {
            this.paint = paint;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (!this.text.equals(text)) {
            this.text = text;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public boolean isValidPosition(int position) {
        return position == 0 || position == 1;
    }

    public double getPreferredWidth(Graphics2D g2) {
        g2.setFont(this.font);
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D titleBounds = this.font.getStringBounds(this.text, frc);
        double result = titleBounds.getWidth();
        if (this.spacer != null) {
            result = this.spacer.getAdjustedWidth(result);
        }
        return result;
    }

    public double getPreferredHeight(Graphics2D g2) {
        g2.setFont(this.font);
        FontRenderContext frc = g2.getFontRenderContext();
        LineMetrics lineMetrics = this.font.getLineMetrics(this.text, frc);
        double result = lineMetrics.getHeight();
        if (this.spacer != null) {
            result = this.spacer.getAdjustedHeight(result);
        }
        return result;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        if (this.position != 0 && this.position != 1) {
            throw new RuntimeException("TextTitle.draw(...) - invalid title position.");
        }
        this.drawHorizontal(g2, area);
    }

    protected void drawHorizontal(Graphics2D g2, Rectangle2D area) {
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D titleBounds = this.font.getStringBounds(this.text, frc);
        LineMetrics lineMetrics = this.font.getLineMetrics(this.text, frc);
        double titleWidth = titleBounds.getWidth();
        double leftSpace = 0.0;
        double rightSpace = 0.0;
        double titleHeight = lineMetrics.getHeight();
        double topSpace = 0.0;
        double bottomSpace = 0.0;
        if (this.spacer != null) {
            leftSpace = this.spacer.getLeftSpace(titleWidth);
            rightSpace = this.spacer.getRightSpace(titleWidth);
            topSpace = this.spacer.getTopSpace(titleHeight);
            bottomSpace = this.spacer.getBottomSpace(titleHeight);
        }
        double titleY = area.getY() + topSpace;
        if (this.verticalAlignment == 0) {
            titleY = titleY + titleHeight - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent();
        } else if (this.verticalAlignment == 4) {
            double space = area.getHeight() - topSpace - bottomSpace - titleHeight;
            titleY = titleY + space / 2.0 + titleHeight - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent();
        } else if (this.verticalAlignment == 1) {
            titleY = area.getMaxY() - bottomSpace - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent();
        }
        double titleX = area.getX() + leftSpace;
        if (this.horizontalAlignment == 4) {
            titleX = titleX + (area.getWidth() - leftSpace - rightSpace) / 2.0 - titleWidth / 2.0;
        } else if (this.horizontalAlignment == 3) {
            titleX = area.getX() + leftSpace;
        } else if (this.horizontalAlignment == 2) {
            titleX = area.getMaxX() - rightSpace - titleWidth;
        }
        g2.setFont(this.font);
        g2.setPaint(this.paint);
        g2.drawString(this.text, (float)titleX, (float)titleY);
    }
}

