/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.tooltips.StandardXYToolTipGenerator;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class StandardXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int IMAGES = 4;
    protected boolean plotShapes;
    protected boolean plotLines;
    protected boolean plotImages;
    protected double shapeScale = 6.0;
    protected Line2D line;

    public StandardXYItemRenderer() {
        this(2, new StandardXYToolTipGenerator());
    }

    public StandardXYItemRenderer(int type, XYToolTipGenerator toolTipGenerator) {
        super(toolTipGenerator);
        if ((type & 1) != 0) {
            this.plotShapes = true;
        }
        if ((type & 2) != 0) {
            this.plotLines = true;
        }
        if ((type & 4) != 0) {
            this.plotImages = true;
        }
        if (type == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotImages() {
        return this.plotImages;
    }

    protected double getShapeScale(Plot plot, int series, int item, double x, double y) {
        return 6.0;
    }

    protected Shape getShape(Plot plot, int series, int item, double x, double y, double scale) {
        return plot.getShape(series, item, x, y, scale);
    }

    protected Image getImage(Plot plot, int series, int item, double x, double y) {
        return null;
    }

    protected Point getImageHotspot(Plot plot, int series, int item, double x, double y, Image image) {
        int height = image.getHeight(null);
        int width = image.getWidth(null);
        return new Point(width / 2, height / 2);
    }

    protected boolean isShapeFilled(Plot plot, int series, int item, double x, double y) {
        return false;
    }

    protected Paint getPaint(Plot plot, int series, int item, double x, double y) {
        return null;
    }

    public void drawItem(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, XYPlot plot, ValueAxis horizontalAxis, ValueAxis verticalAxis, XYDataset data, int series, int item, CrosshairInfo crosshairInfo) {
        Shape entityArea = null;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getEntityCollection();
        }
        Paint seriesPaint = plot.getSeriesPaint(series);
        Stroke seriesStroke = plot.getSeriesStroke(series);
        g2.setPaint(seriesPaint);
        g2.setStroke(seriesStroke);
        Number x1 = data.getXValue(series, item);
        Number y1 = data.getYValue(series, item);
        if (y1 != null) {
            double transY1;
            double transX1 = horizontalAxis.translateValueToJava2D(x1.doubleValue(), dataArea);
            Paint paint = this.getPaint(plot, series, item, transX1, transY1 = verticalAxis.translateValueToJava2D(y1.doubleValue(), dataArea));
            if (paint != null) {
                g2.setPaint(paint);
            }
            if (this.plotLines && item > 0) {
                Number x0 = data.getXValue(series, item - 1);
                Number y0 = data.getYValue(series, item - 1);
                if (y0 != null) {
                    double transX0 = horizontalAxis.translateValueToJava2D(x0.doubleValue(), dataArea);
                    double transY0 = verticalAxis.translateValueToJava2D(y0.doubleValue(), dataArea);
                    this.line.setLine(transX0, transY0, transX1, transY1);
                    if (this.line.intersects(dataArea)) {
                        g2.draw(this.line);
                    }
                }
            }
            if (this.plotShapes) {
                this.shapeScale = this.getShapeScale(plot, series, item, transX1, transY1);
                Shape shape = this.getShape(plot, series, item, transX1, transY1, this.shapeScale);
                if (this.isShapeFilled(plot, series, item, transX1, transY1)) {
                    if (shape.intersects(dataArea)) {
                        g2.fill(shape);
                    }
                } else if (shape.intersects(dataArea)) {
                    g2.draw(shape);
                }
                entityArea = shape;
            }
            if (this.plotImages) {
                this.shapeScale = this.getShapeScale(plot, series, item, transX1, transY1);
                Image image = this.getImage(plot, series, item, transX1, transY1);
                if (image != null) {
                    Point hotspot = this.getImageHotspot(plot, series, item, transX1, transY1, image);
                    g2.drawImage(image, (int)(transX1 - hotspot.getX()), (int)(transY1 - hotspot.getY()), null);
                }
            }
            if (entities != null) {
                if (entityArea == null) {
                    entityArea = new Rectangle2D.Double(transX1 - 2.0, transY1 - 2.0, 4.0, 4.0);
                }
                String tip = "";
                if (this.toolTipGenerator != null) {
                    tip = this.toolTipGenerator.generateToolTip(data, series, item);
                }
                XYItemEntity entity = new XYItemEntity(entityArea, tip, series, item);
                entities.addEntity(entity);
            }
            if (horizontalAxis.isCrosshairLockedOnData()) {
                if (verticalAxis.isCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(x1.doubleValue(), y1.doubleValue());
                } else {
                    crosshairInfo.updateCrosshairX(x1.doubleValue());
                }
            } else if (verticalAxis.isCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(y1.doubleValue());
            }
        }
    }

    static {
        SHAPES = 1;
        LINES = 2;
        SHAPES_AND_LINES = 3;
        IMAGES = 4;
    }
}

