/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.SeriesShapeFactory;
import com.jrefinery.chart.ShapeFactory;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.chart.event.AxisChangeListener;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.event.PlotChangeListener;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetChangeEvent;
import com.jrefinery.data.DatasetChangeListener;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Plot
implements AxisChangeListener,
DatasetChangeListener,
AxisConstants {
    public static final Number ZERO = new Integer(0);
    protected static final Insets DEFAULT_INSETS = new Insets(2, 2, 2, 10);
    protected static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    protected static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    protected static final float DEFAULT_FOREGROUND_ALPHA = 1.0f;
    protected static final float DEFAULT_BACKGROUND_ALPHA = 1.0f;
    protected static final Paint DEFAULT_BACKGROUND_PAINT;
    protected static final int MINIMUM_WIDTH_TO_DRAW = 10;
    protected static final int MINIMUM_HEIGHT_TO_DRAW = 10;
    protected Dataset dataset;
    protected int firstSeriesIndex = 0;
    protected Insets insets;
    protected Stroke outlineStroke;
    protected Paint outlinePaint;
    protected Paint backgroundPaint;
    protected Image backgroundImage;
    protected float foregroundAlpha;
    protected float backgroundAlpha;
    protected Paint[] seriesPaint;
    protected Stroke[] seriesStroke;
    protected Paint[] seriesOutlinePaint;
    protected Stroke[] seriesOutlineStroke;
    protected List listeners;
    protected ShapeFactory shapeFactory;

    protected Plot(Dataset data) {
        this(data, DEFAULT_INSETS, DEFAULT_BACKGROUND_PAINT, null, 1.0f, DEFAULT_OUTLINE_STROKE, DEFAULT_OUTLINE_PAINT, 1.0f);
    }

    protected Plot(Dataset data, Insets insets, Paint backgroundPaint, Image backgroundImage, float backgroundAlpha, Stroke outlineStroke, Paint outlinePaint, float foregroundAlpha) {
        this.dataset = data;
        if (data != null) {
            data.addChangeListener(this);
        }
        this.insets = insets;
        this.backgroundPaint = backgroundPaint;
        this.backgroundAlpha = backgroundAlpha;
        this.outlineStroke = outlineStroke;
        this.outlinePaint = outlinePaint;
        this.foregroundAlpha = foregroundAlpha;
        this.seriesStroke = new Stroke[]{new BasicStroke(1.0f)};
        this.seriesPaint = new Paint[]{Color.red, Color.blue, Color.green, Color.yellow, Color.orange, Color.magenta, Color.cyan, Color.pink, Color.lightGray};
        this.seriesOutlinePaint = new Paint[]{Color.gray};
        this.seriesOutlineStroke = new Stroke[]{new BasicStroke(0.5f)};
        this.listeners = new ArrayList();
        this.shapeFactory = new SeriesShapeFactory();
    }

    public abstract String getPlotType();

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset data) {
        Dataset existing = this.dataset;
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.dataset = data;
        if (this.dataset != null) {
            this.dataset.addChangeListener(this);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, data);
        this.datasetChanged(event);
    }

    public boolean isSubplot() {
        return false;
    }

    public int getFirstSeriesIndex() {
        return this.firstSeriesIndex;
    }

    public void setFirstSeriesIndex(int index) {
        this.firstSeriesIndex = index;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        if (!this.insets.equals(insets)) {
            this.insets = insets;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            if (this.backgroundPaint != null) {
                this.backgroundPaint = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.backgroundPaint != null && this.backgroundPaint.equals(paint)) {
                return;
            }
            this.backgroundPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(float alpha) {
        if (this.backgroundAlpha != alpha) {
            this.backgroundAlpha = alpha;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            if (this.outlineStroke != null) {
                this.outlineStroke = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.outlineStroke != null && this.outlineStroke.equals(stroke)) {
                return;
            }
            this.outlineStroke = stroke;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            if (this.outlinePaint != null) {
                this.outlinePaint = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.outlinePaint != null && this.outlinePaint.equals(paint)) {
                return;
            }
            this.outlinePaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(float alpha) {
        if (this.foregroundAlpha != alpha) {
            this.foregroundAlpha = alpha;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public abstract List getLegendItemLabels();

    public Paint getSeriesPaint(int index) {
        if (this.isSubplot()) {
            index += this.firstSeriesIndex;
        }
        return this.seriesPaint[index % this.seriesPaint.length];
    }

    public void setSeriesPaint(Paint[] paint) {
        this.seriesPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setSeriesPaint(int index, Paint paint) {
        if (this.isSubplot()) {
            index += this.firstSeriesIndex;
        }
        this.seriesPaint[index] = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSeriesStroke(int index) {
        return this.seriesStroke[index % this.seriesStroke.length];
    }

    public void setSeriesStroke(Stroke[] stroke) {
        this.seriesStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setSeriesStroke(int index, Stroke stroke) {
        this.seriesStroke[index] = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSeriesOutlinePaint(int index) {
        return this.seriesOutlinePaint[index % this.seriesOutlinePaint.length];
    }

    public void setSeriesOutlinePaint(Paint[] paint) {
        this.seriesOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSeriesOutlineStroke(int index) {
        return this.seriesOutlineStroke[index % this.seriesOutlinePaint.length];
    }

    public void setSeriesOutlineStroke(Stroke[] stroke) {
        this.seriesOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setSeriesOutlineStroke(int index, Stroke stroke) {
        this.seriesOutlineStroke[index] = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ShapeFactory getShapeFactory() {
        return this.shapeFactory;
    }

    public void setShapeFactory(ShapeFactory factory) {
        this.shapeFactory = factory;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Shape getShape(int series, int item, double x, double y, double scale) {
        Shape shape = null;
        if (this.shapeFactory != null) {
            shape = this.shapeFactory.getShape(series, item, x, y, scale);
        }
        return shape;
    }

    public Shape getShape(int series, Object category, double x, double y, double scale) {
        Shape shape = null;
        if (this.shapeFactory != null) {
            shape = this.shapeFactory.getShape(series, category, x, y, scale);
        }
        return shape;
    }

    public void notifyListeners(PlotChangeEvent event) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            PlotChangeListener listener = (PlotChangeListener)iterator.next();
            listener.plotChanged(event);
        }
    }

    public void addChangeListener(PlotChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(PlotChangeListener listener) {
        this.listeners.remove(listener);
    }

    public abstract void draw(Graphics2D var1, Rectangle2D var2, ChartRenderingInfo var3);

    public void drawOutlineAndBackground(Graphics2D g2, Rectangle2D area) {
        Composite originalComposite;
        if (this.backgroundPaint != null) {
            originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, this.backgroundAlpha));
            g2.setPaint(this.backgroundPaint);
            g2.fill(area);
            g2.setComposite(originalComposite);
        }
        if (this.backgroundImage != null) {
            originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.15f));
            g2.drawImage(this.backgroundImage, (int)area.getX(), (int)area.getY(), (int)area.getWidth(), (int)area.getHeight(), null);
            g2.setComposite(originalComposite);
        }
        if (this.outlineStroke != null && this.outlinePaint != null) {
            g2.setStroke(this.outlineStroke);
            g2.setPaint(this.outlinePaint);
            g2.draw(area);
        }
    }

    public void handleClick(int x, int y, ChartRenderingInfo info) {
    }

    public abstract void zoom(double var1);

    public void axisChanged(AxisChangeEvent event) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void datasetChanged(DatasetChangeEvent event) {
        PlotChangeEvent newEvent = new PlotChangeEvent(this);
        this.notifyListeners(newEvent);
    }

    static {
        DEFAULT_FOREGROUND_ALPHA = 1.0f;
        DEFAULT_BACKGROUND_ALPHA = 1.0f;
        DEFAULT_BACKGROUND_PAINT = Color.white;
        MINIMUM_WIDTH_TO_DRAW = 10;
        MINIMUM_HEIGHT_TO_DRAW = 10;
    }
}

