/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.entity.PieSectionEntity;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.tooltips.PieToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardPieToolTipGenerator;
import com.jrefinery.data.PieDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PiePlot
extends Plot {
    public static final int CLOCKWISE = -1;
    public static final int ANTICLOCKWISE = 1;
    public static final double DEFAULT_INTERIOR_GAP = 0.2;
    public static final double MAX_INTERIOR_GAP = 0.4;
    public static final double DEFAULT_RADIUS = 1.0;
    public static final double MAX_RADIUS = 1.0;
    public static final Font DEFAULT_SECTION_LABEL_FONT;
    public static final Paint DEFAULT_SECTION_LABEL_PAINT;
    public static final double DEFAULT_SECTION_LABEL_GAP = 0.1;
    public static final double MAX_SECTION_LABEL_GAP = 0.3;
    public static final int NO_LABELS = 0;
    public static final int NAME_LABELS = 1;
    public static final int VALUE_LABELS = 2;
    public static final int PERCENT_LABELS = 3;
    public static final int NAME_AND_VALUE_LABELS = 4;
    public static final int NAME_AND_PERCENT_LABELS = 5;
    public static final int VALUE_AND_PERCENT_LABELS = 6;
    protected double interiorGapPercent;
    protected boolean circular;
    protected int direction = -1;
    protected double startAngle = 90.0;
    protected double radiusPercent;
    protected int sectionLabelType;
    protected Font sectionLabelFont;
    protected Paint sectionLabelPaint;
    protected double sectionLabelGapPercent;
    protected double[] explodePercentages;
    protected DecimalFormat valueFormatter;
    protected DecimalFormat percentFormatter;
    protected PieToolTipGenerator toolTipGenerator;

    public PiePlot(PieDataset data) {
        this(data, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 0.2, true, 1.0, 1, DEFAULT_SECTION_LABEL_FONT, DEFAULT_SECTION_LABEL_PAINT, 0.1, "0.00", "0.0", null);
    }

    public PiePlot(PieDataset data, Insets insets, Paint backgroundPaint, Image backgroundImage, float backgroundAlpha, Stroke outlineStroke, Paint outlinePaint, float foregroundAlpha, double interiorGapPercent, boolean circular, double radiusPercent, int sectionLabelType, Font sectionLabelFont, Paint sectionLabelPaint, double sectionLabelGapPercent, String valueFormatString, String percentFormatString, PieToolTipGenerator tooltipGenerator) {
        super(data, insets, backgroundPaint, backgroundImage, backgroundAlpha, outlineStroke, outlinePaint, foregroundAlpha);
        this.interiorGapPercent = interiorGapPercent;
        this.circular = circular;
        this.radiusPercent = radiusPercent;
        this.sectionLabelType = sectionLabelType;
        this.sectionLabelFont = sectionLabelFont;
        this.sectionLabelPaint = sectionLabelPaint;
        this.sectionLabelGapPercent = sectionLabelGapPercent;
        this.valueFormatter = new DecimalFormat(valueFormatString);
        this.percentFormatter = new DecimalFormat(percentFormatString);
        this.explodePercentages = null;
        this.toolTipGenerator = tooltipGenerator;
        this.setInsets(insets);
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double angle) {
        this.startAngle = angle;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (direction != -1 && direction != 1) {
            throw new IllegalArgumentException("PiePlot.setDirection(int): invalid direction.");
        }
        this.direction = direction;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getInteriorGapPercent() {
        return this.interiorGapPercent;
    }

    public void setInteriorGapPercent(double percent) {
        if (percent < 0.0 || percent > 0.4) {
            throw new IllegalArgumentException("PiePlot.setInteriorGapPercent(double): percentage outside valid range.");
        }
        if (this.interiorGapPercent != percent) {
            this.interiorGapPercent = percent;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean flag) {
        if (this.circular != flag) {
            this.circular = flag;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRadiusPercent() {
        return this.radiusPercent;
    }

    public void setRadiusPercent(double percent) {
        if (percent <= 0.0 || percent > 1.0) {
            throw new IllegalArgumentException("PiePlot.setRadiusPercent(double): percentage outside valid range.");
        }
        if (this.radiusPercent != percent) {
            this.radiusPercent = percent;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public int getSectionLabelType() {
        return this.sectionLabelType;
    }

    public void setSectionLabelType(int type) {
        if (type != 0 && type != 1 && type != 2 && type != 3 && type != 4 && type != 5 && type != 6) {
            throw new IllegalArgumentException("PiePlot.setSectionLabelType(int): unrecognised type.");
        }
        if (this.sectionLabelType != type) {
            this.sectionLabelType = type;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getSectionLabelFont() {
        return this.sectionLabelFont;
    }

    public void setSectionLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("PiePlot.setSectionLabelFont(...): null font not allowed.");
        }
        if (!this.sectionLabelFont.equals(font)) {
            this.sectionLabelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getSectionLabelPaint() {
        return this.sectionLabelPaint;
    }

    public void setSectionLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("PiePlot.setSectionLabelPaint(...): null paint not allowed.");
        }
        if (!this.sectionLabelPaint.equals(paint)) {
            this.sectionLabelPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getSectionLabelGapPercent() {
        return this.sectionLabelGapPercent;
    }

    public void setSectionLabelGapPercent(double percent) {
        if (percent < 0.0 || percent > 0.3) {
            throw new IllegalArgumentException("PiePlot.setSectionLabelGapPercent(double): percentage outside valid range.");
        }
        if (this.sectionLabelGapPercent != percent) {
            this.sectionLabelGapPercent = percent;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setValueFormatString(String format) {
        this.valueFormatter = new DecimalFormat(format);
    }

    public void setPercentFormatString(String format) {
        this.percentFormatter = new DecimalFormat(format);
    }

    public double getExplodePercent(int section) {
        if (section < 0) {
            throw new IllegalArgumentException("PiePlot.getExplodePercent(int): section outside valid range.");
        }
        double result = 0.0;
        if (this.explodePercentages != null && section < this.explodePercentages.length) {
            result = this.explodePercentages[section];
        }
        return result;
    }

    public void setExplodePercent(int section, double percent) {
        if (section < 0 || section >= this.getPieDataset().getCategories().size()) {
            throw new IllegalArgumentException("PiePlot.setExplodePercent(int, double): section outside valid range.");
        }
        if (this.explodePercentages != null) {
            if (section < this.explodePercentages.length) {
                this.explodePercentages[section] = percent;
            } else {
                double[] newExplodePercentages = new double[section];
                int i = 0;
                while (i < this.explodePercentages.length) {
                    newExplodePercentages[i] = this.explodePercentages[i];
                    ++i;
                }
                this.explodePercentages = newExplodePercentages;
                this.explodePercentages[section] = percent;
            }
        } else {
            this.explodePercentages = new double[this.getPieDataset().getCategories().size()];
            this.explodePercentages[section] = percent;
        }
    }

    public PieDataset getPieDataset() {
        return (PieDataset)this.dataset;
    }

    public Collection getCategories() {
        return this.getPieDataset().getCategories();
    }

    public List getLegendItemLabels() {
        ArrayList<String> result = new ArrayList<String>();
        PieDataset pieData = this.getPieDataset();
        List categories = pieData.getCategories();
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next().toString());
        }
        return result;
    }

    public PieToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(PieToolTipGenerator generator) {
        this.toolTipGenerator = generator;
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, ChartRenderingInfo info) {
        if (this.insets != null) {
            plotArea.setRect(plotArea.getX() + (double)this.insets.left, plotArea.getY() + (double)this.insets.top, plotArea.getWidth() - (double)this.insets.left - (double)this.insets.right, plotArea.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        if (info != null) {
            info.setPlotArea(plotArea);
            info.setDataArea(plotArea);
        }
        this.drawOutlineAndBackground(g2, plotArea);
        double gapHorizontal = plotArea.getWidth() * this.interiorGapPercent;
        double gapVertical = plotArea.getHeight() * this.interiorGapPercent;
        double pieX = plotArea.getX() + gapHorizontal / 2.0;
        double pieY = plotArea.getY() + gapVertical / 2.0;
        double pieW = plotArea.getWidth() - gapHorizontal;
        double pieH = plotArea.getHeight() - gapVertical;
        if (this.circular) {
            double min = Math.min(pieW, pieH) / 2.0;
            pieX = (pieX + pieX + pieW) / 2.0 - min;
            pieY = (pieY + pieY + pieH) / 2.0 - min;
            pieW = 2.0 * min;
            pieH = 2.0 * min;
        }
        Rectangle2D.Double explodedPieArea = new Rectangle2D.Double(pieX, pieY, pieW, pieH);
        double explodeHorizontal = (1.0 - this.radiusPercent) * pieW;
        double explodeVertical = (1.0 - this.radiusPercent) * pieH;
        Rectangle2D.Double pieArea = new Rectangle2D.Double(pieX + explodeHorizontal / 2.0, pieY + explodeVertical / 2.0, pieW - explodeHorizontal, pieH - explodeVertical);
        PieDataset data = this.getPieDataset();
        if (data != null) {
            Shape savedClip = g2.getClip();
            g2.clip(plotArea);
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
            List categories = data.getCategories();
            double totalValue = 0.0;
            Iterator iterator = categories.iterator();
            while (iterator.hasNext()) {
                Number value;
                double v;
                Object current = iterator.next();
                if (current == null || !((v = (value = data.getValue(current)).doubleValue()) > 0.0)) continue;
                totalValue += v;
            }
            double runningTotal = 0.0;
            int section = 0;
            iterator = categories.iterator();
            while (iterator.hasNext()) {
                double value;
                Object current = iterator.next();
                Number dataValue = data.getValue(current);
                if (dataValue != null && (value = dataValue.doubleValue()) > 0.0) {
                    double angle1 = this.startAngle + (double)this.direction * (runningTotal * 360.0) / totalValue;
                    double angle2 = this.startAngle + (double)this.direction * (runningTotal + value) * 360.0 / totalValue;
                    Rectangle2D arcBounds = this.getArcBounds(pieArea, explodedPieArea, angle1, angle2 - angle1, this.getExplodePercent(section));
                    Arc2D.Double arc = new Arc2D.Double(arcBounds, angle1, angle2 - angle1, 2);
                    runningTotal += value;
                    Paint paint = this.getSeriesPaint(section);
                    Paint outlinePaint = this.getSeriesOutlinePaint(section);
                    g2.setPaint(paint);
                    g2.fill(arc);
                    g2.setStroke(new BasicStroke());
                    g2.setPaint(outlinePaint);
                    g2.draw(arc);
                    if (info != null) {
                        if (this.toolTipGenerator == null) {
                            this.toolTipGenerator = new StandardPieToolTipGenerator();
                        }
                        String tip = this.toolTipGenerator.generateToolTip(data, current);
                        PieSectionEntity entity = new PieSectionEntity(arc, tip, current, section);
                        info.getEntityCollection().addEntity(entity);
                    }
                    if (this.sectionLabelType != 0) {
                        this.drawLabel(g2, pieArea, explodedPieArea, data, value, section, angle1, angle2 - angle1);
                    }
                }
                ++section;
            }
            g2.clip(savedClip);
            g2.setComposite(originalComposite);
        }
    }

    protected void drawLabel(Graphics2D g2, Rectangle2D pieArea, Rectangle2D explodedPieArea, PieDataset data, double value, int section, double startAngle, double extent) {
        FontRenderContext frc = g2.getFontRenderContext();
        List legendItemLabels = this.getLegendItemLabels();
        String label = "";
        if (this.sectionLabelType == 1) {
            label = legendItemLabels.get(section).toString();
        } else if (this.sectionLabelType == 2) {
            label = this.valueFormatter.format(value);
        } else if (this.sectionLabelType == 3) {
            label = this.percentFormatter.format(extent / 3.6) + "%";
        } else if (this.sectionLabelType == 4) {
            label = legendItemLabels.get(section).toString() + " (" + this.valueFormatter.format(value) + ")";
        } else if (this.sectionLabelType == 5) {
            label = legendItemLabels.get(section).toString() + " (" + this.percentFormatter.format(extent / 3.6) + "%)";
        } else if (this.sectionLabelType == 6) {
            label = this.valueFormatter.format(value) + " (" + this.percentFormatter.format(extent / 3.6) + "%)";
        }
        Rectangle2D labelBounds = this.sectionLabelFont.getStringBounds(label, frc);
        LineMetrics lm = this.sectionLabelFont.getLineMetrics(label, frc);
        double ascent = lm.getAscent();
        Point2D labelLocation = this.calculateLabelLocation(labelBounds, ascent, pieArea, explodedPieArea, startAngle, extent, this.getExplodePercent(section));
        g2.setPaint(this.sectionLabelPaint);
        g2.setFont(this.sectionLabelFont);
        g2.drawString(label, (float)labelLocation.getX(), (float)labelLocation.getY());
    }

    public String getPlotType() {
        return "Pie Plot";
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis == null;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis == null;
    }

    public void zoom(double percent) {
    }

    protected Rectangle2D getArcBounds(Rectangle2D unexploded, Rectangle2D exploded, double startAngle, double extent, double explodePercent) {
        if (explodePercent == 0.0) {
            return unexploded;
        }
        Arc2D.Double arc1 = new Arc2D.Double(unexploded, startAngle, extent / 2.0, 0);
        Point2D point1 = arc1.getEndPoint();
        Arc2D.Double arc2 = new Arc2D.Double(exploded, startAngle, extent / 2.0, 0);
        Point2D point2 = arc2.getEndPoint();
        double deltaX = (point1.getX() - point2.getX()) * explodePercent;
        double deltaY = (point1.getY() - point2.getY()) * explodePercent;
        return new Rectangle2D.Double(unexploded.getX() - deltaX, unexploded.getY() - deltaY, unexploded.getWidth(), unexploded.getHeight());
    }

    protected Point2D calculateLabelLocation(Rectangle2D labelBounds, double ascent, Rectangle2D unexploded, Rectangle2D exploded, double startAngle, double extent, double explodePercent) {
        Arc2D.Double arc1 = new Arc2D.Double(unexploded, startAngle, extent / 2.0, 0);
        Point2D point1 = arc1.getEndPoint();
        Arc2D.Double arc2 = new Arc2D.Double(exploded, startAngle, extent / 2.0, 0);
        Point2D point2 = arc2.getEndPoint();
        double deltaX = (point1.getX() - point2.getX()) * explodePercent;
        double deltaY = (point1.getY() - point2.getY()) * explodePercent;
        double labelX = point1.getX() - (deltaX -= (point1.getX() - unexploded.getCenterX()) * this.sectionLabelGapPercent);
        double labelY = point1.getY() - (deltaY -= (point1.getY() - unexploded.getCenterY()) * this.sectionLabelGapPercent);
        if (labelX <= unexploded.getCenterX()) {
            labelX -= labelBounds.getWidth();
        }
        if (labelY > unexploded.getCenterY()) {
            labelY += ascent;
        }
        return new Point2D.Double(labelX, labelY);
    }

    static {
        CLOCKWISE = -1;
        ANTICLOCKWISE = 1;
        DEFAULT_INTERIOR_GAP = 0.2;
        MAX_INTERIOR_GAP = 0.4;
        DEFAULT_RADIUS = 1.0;
        MAX_RADIUS = 1.0;
        DEFAULT_SECTION_LABEL_FONT = new Font("SansSerif", 0, 10);
        DEFAULT_SECTION_LABEL_PAINT = Color.black;
        DEFAULT_SECTION_LABEL_GAP = 0.1;
        MAX_SECTION_LABEL_GAP = 0.3;
        NO_LABELS = 0;
        NAME_LABELS = 1;
        VALUE_LABELS = 2;
        PERCENT_LABELS = 3;
        NAME_AND_VALUE_LABELS = 4;
        NAME_AND_PERCENT_LABELS = 5;
        VALUE_AND_PERCENT_LABELS = 6;
    }
}

