/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.Range;
import com.jrefinery.data.XYDataset;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class PeriodMarkerPlot
extends XYPlot
implements HorizontalValuePlot,
VerticalValuePlot {
    public PeriodMarkerPlot(XYDataset data, ValueAxis domainAxis, ValueAxis rangeAxis) throws AxisNotCompatibleException, PlotNotCompatibleException {
        super(data, domainAxis, rangeAxis);
    }

    public List getLegendItemLabels() {
        return null;
    }

    public String getPlotType() {
        return "Period Marker Plot";
    }

    public Range getVerticalDataRange() {
        Range result = null;
        if (this.dataset != null) {
            result = DatasetUtilities.getRangeExtent(this.dataset);
        }
        return result;
    }

    public XYDataset getTempXYDataset() {
        return (XYDataset)this.dataset;
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        if (axis instanceof HorizontalNumberAxis) {
            return true;
        }
        return axis instanceof HorizontalDateAxis;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalNumberAxis;
    }

    public Range getHorizontalDataRange() {
        return null;
    }

    public Range getVerticalRange() {
        return null;
    }

    public Number getMinimumVerticalDataValue() {
        return new Double(Double.POSITIVE_INFINITY);
    }

    public Number getMaximumVerticalDataValue() {
        return null;
    }

    public void draw(Graphics2D g2, Rectangle2D drawArea, ChartRenderingInfo info) {
        if (this.insets != null) {
            drawArea = new Rectangle2D.Double(drawArea.getX() + (double)this.insets.left, drawArea.getY() + (double)this.insets.top, drawArea.getWidth() - (double)this.insets.left - (double)this.insets.right, drawArea.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        HorizontalAxis ha = this.getHorizontalAxis();
        VerticalAxis va = this.getVerticalAxis();
        double h = ha.reserveHeight(g2, this, drawArea);
        Rectangle2D vAxisArea = va.reserveAxisArea(g2, this, drawArea, h);
        Rectangle2D.Double plotArea = new Rectangle2D.Double(drawArea.getX() + vAxisArea.getWidth(), drawArea.getY(), drawArea.getWidth() - vAxisArea.getWidth(), drawArea.getHeight() - h);
        this.drawOutlineAndBackground(g2, plotArea);
        this.domainAxis.draw(g2, drawArea, plotArea);
        this.rangeAxis.draw(g2, drawArea, plotArea);
        Shape originalClip = g2.getClip();
        g2.clip(plotArea);
        XYDataset data = this.getTempXYDataset();
        if (data != null) {
            int seriesCount = data.getSeriesCount();
            int serie = 0;
            while (serie < seriesCount) {
                this.drawMarkedPeriods(data, serie, g2, plotArea);
                ++serie;
            }
        }
        g2.setClip(originalClip);
    }

    private void drawMarkedPeriods(XYDataset data, int serie, Graphics2D g2, Rectangle2D plotArea) {
        Color thisSerieColor;
        int colorSaturation;
        Paint thisSeriePaint = this.getSeriesPaint(serie);
        g2.setPaint(thisSeriePaint);
        g2.setStroke(this.getSeriesStroke(serie));
        float opacity = 0.1f;
        if (thisSeriePaint instanceof Color && (colorSaturation = (thisSerieColor = (Color)thisSeriePaint).getRed() + thisSerieColor.getGreen() + thisSerieColor.getBlue()) > 255) {
            opacity = opacity * (float)colorSaturation / 255.0f;
        }
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, opacity));
        double minY = plotArea.getMinY();
        double maxY = plotArea.getMaxY();
        int itemCount = data.getItemCount(serie);
        int itemIndex = 0;
        while (itemIndex < itemCount) {
            if (data.getYValue(serie, itemIndex).doubleValue() != 0.0) {
                Number xStart = itemIndex > 0 ? (Number)new Long((data.getXValue(serie, itemIndex).longValue() + data.getXValue(serie, itemIndex - 1).longValue()) / 2L) : (Number)data.getXValue(serie, itemIndex);
                int j = itemIndex + 1;
                while (j < itemCount) {
                    if (data.getYValue(serie, j).doubleValue() == 0.0) break;
                    ++j;
                }
                itemIndex = j;
                Number xEnd = j < itemCount ? (Number)new Long((data.getXValue(serie, j - 1).longValue() + data.getXValue(serie, j).longValue()) / 2L) : (Number)data.getXValue(serie, j - 1);
                double xxStart = this.getDomainAxis().translateValueToJava2D(xStart.doubleValue(), plotArea);
                double xxEnd = this.getDomainAxis().translateValueToJava2D(xEnd.doubleValue(), plotArea);
                this.markPeriod(xxStart, xxEnd, minY, maxY, g2);
            }
            ++itemIndex;
        }
        g2.setComposite(originalComposite);
    }

    private void markPeriod(double xStart, double xEnd, double minY, double maxY, Graphics2D g2) {
        g2.fill(new Rectangle2D.Double(xStart, minY, xEnd - xStart, maxY - minY));
    }

    public void zoom(double percent) {
    }
}

