/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.TickUnits;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.Range;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;

public abstract class NumberAxis
extends ValueAxis {
    public static final boolean DEFAULT_AUTO_RANGE_INCLUDES_ZERO = true;
    public static final boolean DEFAULT_AUTO_RANGE_STICKY_ZERO = true;
    public static final double DEFAULT_UPPER_MARGIN = 0.05;
    public static final double DEFAULT_LOWER_MARGIN = 0.05;
    public static final Number DEFAULT_MINIMUM_AUTO_RANGE;
    public static final NumberTickUnit DEFAULT_TICK_UNIT;
    protected boolean inverted;
    protected boolean autoRangeIncludesZero;
    protected boolean autoRangeStickyZero;
    protected Number autoRangeMinimumSize;
    protected double upperMargin;
    protected double lowerMargin;
    protected NumberTickUnit tickUnit;
    protected TickUnits standardTickUnits;

    protected NumberAxis(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, true, true, DEFAULT_MINIMUM_AUTO_RANGE, 0.0, 1.0, false, true, DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    protected NumberAxis(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean tickLabelsVisible, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean tickMarksVisible, Stroke tickMarkStroke, boolean autoRange, boolean autoRangeIncludesZero, boolean autoRangeStickyZero, Number autoRangeMinimumSize, double minimumAxisValue, double maximumAxisValue, boolean inverted, boolean autoTickUnitSelection, NumberTickUnit tickUnit, boolean gridLinesVisible, Stroke gridStroke, Paint gridPaint, boolean crosshairVisible, double crosshairValue, Stroke crosshairStroke, Paint crosshairPaint) {
        super(label, labelFont, labelPaint, labelInsets, tickLabelsVisible, tickLabelFont, tickLabelPaint, tickLabelInsets, tickMarksVisible, tickMarkStroke, autoRange, autoTickUnitSelection, gridLinesVisible, gridStroke, gridPaint, crosshairVisible, crosshairValue, crosshairStroke, crosshairPaint);
        if (minimumAxisValue >= maximumAxisValue) {
            throw new IllegalArgumentException("NumberAxis(...): minimum axis value must be less than maximum axis value.");
        }
        if (autoRangeMinimumSize == null) {
            throw new IllegalArgumentException("NumberAxis(...): autoRangeMinimum cannot be null.");
        }
        this.autoRangeIncludesZero = autoRangeIncludesZero;
        this.autoRangeStickyZero = autoRangeStickyZero;
        this.autoRangeMinimumSize = autoRangeMinimumSize;
        this.range = new Range(minimumAxisValue, maximumAxisValue);
        this.anchorValue = 0.0;
        this.inverted = inverted;
        this.tickUnit = tickUnit;
        this.upperMargin = 0.05;
        this.lowerMargin = 0.05;
        this.standardTickUnits = TickUnits.createStandardTickUnits();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean flag) {
        if (this.inverted != flag) {
            this.inverted = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean autoRangeIncludesZero() {
        return this.autoRangeIncludesZero;
    }

    public void setAutoRangeIncludesZero(boolean flag) {
        if (this.autoRangeIncludesZero != flag) {
            this.autoRangeIncludesZero = flag;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean autoRangeStickyZero() {
        return this.autoRangeStickyZero;
    }

    public void setAutoRangeStickyZero(boolean flag) {
        if (this.autoRangeStickyZero != flag) {
            this.autoRangeStickyZero = flag;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Number getAutoRangeMinimumSize() {
        return this.autoRangeMinimumSize;
    }

    public void setAutoRangeMinimumSize(Number size) {
        if (size == null) {
            throw new IllegalArgumentException("NumberAxis.setAutoRangeMinimumSize(Number): null not permitted.");
        }
        if (this.autoRangeMinimumSize.doubleValue() != size.doubleValue()) {
            this.autoRangeMinimumSize = size;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double margin) {
        this.upperMargin = margin;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double margin) {
        this.lowerMargin = margin;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public TickUnits getStandardTickUnits() {
        return this.standardTickUnits;
    }

    public void setStandardTickUnits(TickUnits collection) {
        this.standardTickUnits = collection;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit unit) {
        this.autoTickUnitSelection = false;
        this.tickUnit = unit;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double calculateLowestVisibleTickValue() {
        double unit = this.getTickUnit().getSize();
        double index = Math.ceil(this.range.getLowerBound() / unit);
        return index * unit;
    }

    public double calculateHighestVisibleTickValue() {
        double unit = this.getTickUnit().getSize();
        double index = Math.floor(this.range.getUpperBound() / unit);
        return index * unit;
    }

    public int calculateVisibleTickCount() {
        double unit = this.getTickUnit().getSize();
        return (int)(Math.floor(this.range.getUpperBound() / unit) - Math.ceil(this.range.getLowerBound() / unit) + 1.0);
    }

    static {
        DEFAULT_AUTO_RANGE_INCLUDES_ZERO = true;
        DEFAULT_AUTO_RANGE_STICKY_ZERO = true;
        DEFAULT_UPPER_MARGIN = 0.05;
        DEFAULT_LOWER_MARGIN = 0.05;
        DEFAULT_MINIMUM_AUTO_RANGE = new Double(1.0E-7);
        DEFAULT_TICK_UNIT = new NumberTickUnit(1.0, new DecimalFormat("0"));
    }
}

