/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractCategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;

public class LineAndShapeRenderer
extends AbstractCategoryItemRenderer {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    protected boolean plotShapes;
    protected boolean plotLines;
    protected double shapeScale = 6.0;
    protected int labelPosition;

    public LineAndShapeRenderer() {
        this(3, 1);
    }

    public LineAndShapeRenderer(int type) {
        this(type, 1);
    }

    public LineAndShapeRenderer(int type, int labelPosition) {
        if (type == 1) {
            this.plotShapes = true;
        }
        if (type == 2) {
            this.plotLines = true;
        }
        if (type == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        this.labelPosition = labelPosition;
    }

    public Rectangle2D getAxisArea(Rectangle2D plotArea) {
        return plotArea;
    }

    public void drawRangeMarker(Graphics2D g2, CategoryPlot plot, ValueAxis axis, Marker marker, Rectangle2D axisDataArea, Shape dataClipRegion) {
        double value = marker.getValue();
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        double y = axis.translateValueToJava2D(marker.getValue(), axisDataArea);
        Line2D.Double line = new Line2D.Double(axisDataArea.getMinX(), y, axisDataArea.getMaxX(), y);
        g2.setPaint(marker.getOutlinePaint());
        g2.draw(line);
    }

    public void drawCategoryItem(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, int series, Object category, int categoryIndex, Object previousCategory) {
        Number value = data.getValue(series, category);
        if (value != null) {
            EntityCollection entities;
            Number previousValue;
            double x1 = plot.getCategoryCoordinate(categoryIndex, dataArea);
            double y1 = axis.translateValueToJava2D(value.doubleValue(), dataArea);
            g2.setPaint(plot.getSeriesPaint(series));
            g2.setStroke(plot.getSeriesStroke(series));
            Shape shape = null;
            if (this.plotShapes) {
                shape = plot.getShape(series, category, x1, y1, this.shapeScale);
                g2.fill(shape);
            } else {
                shape = new Rectangle2D.Double(x1 - 2.0, y1 - 2.0, 4.0, 4.0);
            }
            if (this.plotLines && previousCategory != null && (previousValue = data.getValue(series, previousCategory)) != null) {
                double previous = previousValue.doubleValue();
                double x0 = plot.getCategoryCoordinate(categoryIndex - 1, dataArea);
                double y0 = axis.translateValueToJava2D(previous, dataArea);
                g2.setPaint(plot.getSeriesPaint(series));
                g2.setStroke(plot.getSeriesStroke(series));
                Line2D.Double line = new Line2D.Double(x0, y0, x1, y1);
                g2.draw(line);
            }
            if (plot.getLabelsVisible()) {
                NumberFormat formatter = plot.getLabelFormatter();
                Font labelFont = plot.getLabelFont();
                g2.setFont(labelFont);
                Paint paint = plot.getLabelPaint();
                g2.setPaint(paint);
                boolean rotate = plot.getVerticalLabels();
                String label = formatter.format(value);
                this.drawLabel(g2, label, x1, y1, labelFont, rotate);
            }
            if (this.info != null && (entities = this.info.getEntityCollection()) != null && shape != null) {
                String tip = "";
                if (this.toolTipGenerator != null) {
                    tip = this.toolTipGenerator.generateToolTip(data, series, category);
                }
                CategoryItemEntity entity = new CategoryItemEntity(shape, tip, series, category, categoryIndex);
                entities.addEntity(entity);
            }
        }
    }

    private void drawLabel(Graphics2D g2, String label, double x, double y, Font labelFont, boolean rotate) {
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D labelBounds = labelFont.getStringBounds(label, frc);
        LineMetrics lm = labelFont.getLineMetrics(label, frc);
        float lead = lm.getLeading();
        double width = labelBounds.getWidth();
        double height = labelBounds.getHeight();
        int position = this.labelPosition;
        if (rotate) {
            float labely;
            float labelx;
            if (position == 1) {
                labelx = (float)(x + height / 2.0 - (double)lm.getDescent());
                labely = (float)(y - this.shapeScale);
            } else if (position == 2) {
                labelx = (float)(x + height / 2.0 - (double)lm.getDescent());
                labely = (float)(y + this.shapeScale + width);
            } else if (position == 3) {
                labelx = (float)(x - this.shapeScale / 2.0 - (double)lead - (double)lm.getDescent());
                labely = (float)(y + width / 2.0);
            } else {
                labelx = (float)(x + this.shapeScale / 2.0 + (double)lead + (double)lm.getAscent());
                labely = (float)(y + width / 2.0);
            }
            RefineryUtilities.drawRotatedString(label, g2, labelx, labely, -1.5707963267948966);
        } else {
            float labely;
            float labelx;
            if (position == 1) {
                labelx = (float)(x - width / 2.0);
                labely = (float)(y - this.shapeScale / 2.0 - (double)lm.getDescent() - (double)lead);
            } else if (position == 2) {
                labelx = (float)(x - width / 2.0);
                labely = (float)(y + this.shapeScale / 2.0 + (double)lm.getAscent() + (double)lead);
            } else if (position == 3) {
                labelx = (float)(x - this.shapeScale - width);
                labely = (float)(y + height / 2.0 - (double)lm.getDescent());
            } else {
                labelx = (float)(x + this.shapeScale);
                labely = (float)(y + height / 2.0 - (double)lm.getDescent());
            }
            g2.drawString(label, labelx, labely);
        }
    }

    static {
        SHAPES = 1;
        LINES = 2;
        SHAPES_AND_LINES = 3;
        TOP = 1;
        BOTTOM = 2;
        LEFT = 3;
        RIGHT = 4;
    }
}

