/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.ThermometerPlot;
import com.jrefinery.data.DefaultMeterDataset;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.text.DecimalFormat;
import javax.swing.JPanel;

public class JThermometer
extends JPanel {
    DefaultMeterDataset data;
    JFreeChart chart;
    ChartPanel panel;
    ThermometerPlot plot = new ThermometerPlot();

    public JThermometer() {
        super(new CardLayout());
        this.plot.setInsets(new Insets(5, 5, 5, 5));
        this.data = new DefaultMeterDataset();
        this.data.setRange(new Double(-60000.0), new Double(60000.0));
        this.plot.setData(this.data);
        this.chart = new JFreeChart(null, JFreeChartConstants.DEFAULT_TITLE_FONT, this.plot, false);
        this.panel = new ChartPanel(this.chart);
        this.add((Component)this.panel, "Panel");
        this.setBackground(this.getBackground());
    }

    public void addTitle(AbstractTitle title) {
        this.chart.addTitle(title);
    }

    public void addTitle(String title) {
        this.chart.addTitle(new TextTitle(title));
    }

    public void addTitle(String title, Font font) {
        this.chart.addTitle(new TextTitle(title, font));
    }

    public void setValueFormat(DecimalFormat df) {
        this.plot.setValueFormat(df);
    }

    public void setRangeInfo(int range, double display_low, double display_hi) {
        this.plot.setRangeInfo(range, display_low, display_hi);
    }

    public void setRangeInfo(int range, double range_low, double range_hi, double display_low, double display_hi) {
        this.plot.setRangeInfo(range, range_low, range_hi, display_low, display_hi);
    }

    public void setDisplayLocation(int loc) {
        this.plot.setDisplayLocation(loc);
        this.panel.repaint();
    }

    public void setValue(double value) {
        this.setValue(new Double(value));
    }

    public void setValue(Number value) {
        if (this.data != null) {
            this.data.setValue(value);
        }
    }

    public Number getValue() {
        if (this.data != null) {
            return this.data.getValue();
        }
        return null;
    }

    public void setUnits(int i) {
        if (this.plot != null) {
            this.plot.setUnits(i);
        }
    }

    public void setOutlinePaint(Paint p) {
        if (this.plot != null) {
            this.plot.setOutlinePaint(p);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.plot != null) {
            this.plot.setThermometerColor(fg);
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.plot != null) {
            this.plot.setBackgroundPaint(bg);
        }
        if (this.chart != null) {
            this.chart.setBackgroundPaint(bg);
        }
        if (this.panel != null) {
            this.panel.setBackground(bg);
        }
    }

    public void setFont(Font f) {
        if (this.plot != null) {
            this.plot.setFont(f);
        }
    }

    public void setValueFont(Font f) {
        if (this.plot != null) {
            this.plot.setValueFont(f);
        }
    }

    public void setFollowData(boolean v) {
        this.plot.setFollowData(v);
    }

    public void setShowValueLines(boolean b) {
        this.plot.setShowValueLines(b);
    }
}

