/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.JFreeChartInfo;
import com.jrefinery.chart.Legend;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.event.ChartChangeEvent;
import com.jrefinery.chart.event.ChartChangeListener;
import com.jrefinery.chart.event.LegendChangeEvent;
import com.jrefinery.chart.event.LegendChangeListener;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.event.PlotChangeListener;
import com.jrefinery.chart.event.TitleChangeEvent;
import com.jrefinery.chart.event.TitleChangeListener;
import com.jrefinery.ui.Drawable;
import com.jrefinery.ui.about.ProjectInfo;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JFreeChart
implements JFreeChartConstants,
Drawable,
TitleChangeListener,
LegendChangeListener,
PlotChangeListener {
    public static final ProjectInfo INFO = new JFreeChartInfo();
    protected List titles;
    protected Legend legend;
    protected Plot plot;
    protected boolean antialias;
    protected Paint backgroundPaint;
    protected Image backgroundImage;
    protected float backgroundImageAlpha = 0.5f;
    protected List listeners;
    private Rectangle2D titleArea = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private Rectangle2D nonTitleArea = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);

    public JFreeChart(Plot plot) {
        this(null, null, plot, false);
    }

    public JFreeChart(String title, Font titleFont, Plot plot, boolean createLegend) {
        this.listeners = new ArrayList();
        this.plot = plot;
        plot.addChangeListener(this);
        this.titles = new ArrayList();
        if (createLegend) {
            this.legend = Legend.createInstance(this);
            this.legend.addChangeListener(this);
        }
        this.antialias = true;
        this.backgroundPaint = JFreeChartConstants.DEFAULT_BACKGROUND_PAINT;
        if (title != null) {
            if (titleFont == null) {
                titleFont = JFreeChartConstants.DEFAULT_TITLE_FONT;
            }
            TextTitle textTitle = new TextTitle(title, titleFont);
            textTitle.addChangeListener(this);
            this.titles.add(textTitle);
        }
    }

    public List getTitles() {
        return this.titles;
    }

    public void setTitles(List titles) {
        this.titles = titles;
        this.fireChartChanged();
    }

    public int getTitleCount() {
        return this.titles.size();
    }

    public AbstractTitle getTitle(int index) {
        if (index < 0 || index == this.getTitleCount()) {
            throw new IllegalArgumentException("JFreeChart.getTitle(...): index out of range.");
        }
        return (AbstractTitle)this.titles.get(index);
    }

    public void addTitle(AbstractTitle title) {
        if (title != null) {
            this.titles.add(title);
            title.addChangeListener(this);
            this.fireChartChanged();
        }
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend legend) {
        Legend existing = this.legend;
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.legend = legend;
        if (legend != null) {
            legend.addChangeListener(this);
        }
        this.fireChartChanged();
    }

    public Plot getPlot() {
        return this.plot;
    }

    public CategoryPlot getCategoryPlot() {
        return (CategoryPlot)this.plot;
    }

    public XYPlot getXYPlot() {
        return (XYPlot)this.plot;
    }

    public boolean getAntiAlias() {
        return this.antialias;
    }

    public void setAntiAlias(boolean flag) {
        if (this.antialias != flag) {
            this.antialias = flag;
            this.fireChartChanged();
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (this.backgroundPaint != null) {
            if (!this.backgroundPaint.equals(paint)) {
                this.backgroundPaint = paint;
                this.fireChartChanged();
            }
        } else if (paint != null) {
            this.backgroundPaint = paint;
            this.fireChartChanged();
        }
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        if (this.backgroundImage != null) {
            if (!this.backgroundImage.equals(image)) {
                this.backgroundImage = image;
                this.fireChartChanged();
            }
        } else if (image != null) {
            this.backgroundImage = image;
            this.fireChartChanged();
        }
    }

    public float getBackgroundImageAlpha() {
        return this.backgroundImageAlpha;
    }

    public void setBackgroundImageAlpha(float alpha) {
        if (this.backgroundImageAlpha != alpha) {
            this.backgroundImageAlpha = alpha;
            this.fireChartChanged();
        }
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        this.draw(g2, area, null);
    }

    public void draw(Graphics2D g2, Rectangle2D chartArea, ChartRenderingInfo info) {
        if (info != null) {
            info.clear();
            info.setChartArea(chartArea);
        }
        Shape savedClip = g2.getClip();
        g2.clip(chartArea);
        if (this.antialias) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.backgroundPaint != null) {
            g2.setPaint(this.backgroundPaint);
            g2.fill(chartArea);
        }
        if (this.backgroundImage != null) {
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, this.backgroundImageAlpha));
            g2.drawImage(this.backgroundImage, (int)chartArea.getX(), (int)chartArea.getY(), (int)chartArea.getWidth(), (int)chartArea.getHeight(), null);
            g2.setComposite(originalComposite);
        }
        this.nonTitleArea.setRect(chartArea);
        Iterator iterator = this.titles.iterator();
        while (iterator.hasNext()) {
            AbstractTitle currentTitle = (AbstractTitle)iterator.next();
            switch (currentTitle.getPosition()) {
                case 0: {
                    double availableHeight = Math.min(currentTitle.getPreferredHeight(g2), this.nonTitleArea.getHeight());
                    double availableWidth = this.nonTitleArea.getWidth();
                    this.titleArea.setRect(this.nonTitleArea.getX(), this.nonTitleArea.getY(), availableWidth, availableHeight);
                    currentTitle.draw(g2, this.titleArea);
                    this.nonTitleArea.setRect(this.nonTitleArea.getX(), Math.min(this.nonTitleArea.getY() + availableHeight, this.nonTitleArea.getMaxY()), availableWidth, Math.max(this.nonTitleArea.getHeight() - availableHeight, 0.0));
                    break;
                }
                case 1: {
                    double availableHeight = Math.min(currentTitle.getPreferredHeight(g2), this.nonTitleArea.getHeight());
                    double availableWidth = this.nonTitleArea.getWidth();
                    this.titleArea.setRect(this.nonTitleArea.getX(), this.nonTitleArea.getMaxY() - availableHeight, availableWidth, availableHeight);
                    currentTitle.draw(g2, this.titleArea);
                    this.nonTitleArea.setRect(this.nonTitleArea.getX(), this.nonTitleArea.getY(), availableWidth, this.nonTitleArea.getHeight() - availableHeight);
                    break;
                }
                case 2: {
                    double availableHeight = this.nonTitleArea.getHeight();
                    double availableWidth = Math.min(currentTitle.getPreferredWidth(g2), this.nonTitleArea.getWidth());
                    this.titleArea.setRect(this.nonTitleArea.getMaxX() - availableWidth, this.nonTitleArea.getY(), availableWidth, availableHeight);
                    currentTitle.draw(g2, this.titleArea);
                    this.nonTitleArea.setRect(this.nonTitleArea.getX(), this.nonTitleArea.getY(), this.nonTitleArea.getWidth() - availableWidth, availableHeight);
                    break;
                }
                case 3: {
                    double availableHeight = this.nonTitleArea.getHeight();
                    double availableWidth = Math.min(currentTitle.getPreferredWidth(g2), this.nonTitleArea.getWidth());
                    this.titleArea.setRect(this.nonTitleArea.getX(), this.nonTitleArea.getY(), availableWidth, availableHeight);
                    currentTitle.draw(g2, this.titleArea);
                    this.nonTitleArea.setRect(this.nonTitleArea.getX() + availableWidth, this.nonTitleArea.getY(), this.nonTitleArea.getWidth() - availableWidth, availableHeight);
                    break;
                }
                default: {
                    throw new RuntimeException("JFreeChart.draw(...): unknown title position.");
                }
            }
        }
        Rectangle2D plotArea = this.nonTitleArea;
        if (this.legend != null) {
            plotArea.setRect(this.legend.draw(g2, this.nonTitleArea));
        }
        this.plot.draw(g2, plotArea, info);
        g2.setClip(savedClip);
    }

    public BufferedImage createBufferedImage(int width, int height) {
        return this.createBufferedImage(width, height, null);
    }

    public BufferedImage createBufferedImage(int width, int height, ChartRenderingInfo info) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2 = image.createGraphics();
        this.draw(g2, new Rectangle2D.Double(0.0, 0.0, width, height), info);
        g2.dispose();
        return image;
    }

    public void handleClick(int x, int y, ChartRenderingInfo info) {
        this.plot.handleClick(x, y, info);
    }

    public void addChangeListener(ChartChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChartChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChartChanged() {
        ChartChangeEvent event = new ChartChangeEvent(this);
        this.notifyListeners(event);
    }

    protected void notifyListeners(ChartChangeEvent event) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ChartChangeListener listener = (ChartChangeListener)iterator.next();
            listener.chartChanged(event);
        }
    }

    public void titleChanged(TitleChangeEvent event) {
        event.setChart(this);
        this.notifyListeners(event);
    }

    public void legendChanged(LegendChangeEvent event) {
        event.setChart(this);
        this.notifyListeners(event);
    }

    public void plotChanged(PlotChangeEvent event) {
        event.setChart(this);
        this.notifyListeners(event);
    }

    public static void main(String[] args) {
        System.out.println(INFO.toString());
    }
}

