/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalMarkerAxisBand;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.TickUnit;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.Range;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class HorizontalNumberAxis
extends NumberAxis
implements HorizontalAxis {
    protected boolean verticalTickLabels;
    protected HorizontalMarkerAxisBand markerBand;

    public HorizontalNumberAxis(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 0.0, 1.0);
        this.autoRange = true;
    }

    public HorizontalNumberAxis(String label, Font labelFont, double minimumAxisValue, double maximumAxisValue) {
        this(label, labelFont, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, true, AxisConstants.DEFAULT_TICK_STROKE, false, true, true, NumberAxis.DEFAULT_MINIMUM_AUTO_RANGE, minimumAxisValue, maximumAxisValue, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    public HorizontalNumberAxis(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean tickLabelsVisible, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean verticalTickLabels, boolean tickMarksVisible, Stroke tickMarkStroke, boolean autoRange, boolean autoRangeIncludesZero, boolean autoRangeStickyZero, Number autoRangeMinimumSize, double minimumAxisValue, double maximumAxisValue, boolean inverted, boolean autoTickUnitSelection, NumberTickUnit tickUnit, boolean gridLinesVisible, Stroke gridStroke, Paint gridPaint, boolean crosshairVisible, double crosshairValue, Stroke crosshairStroke, Paint crosshairPaint) {
        super(label, labelFont, labelPaint, labelInsets, tickLabelsVisible, tickLabelFont, tickLabelPaint, tickLabelInsets, tickMarksVisible, tickMarkStroke, autoRange, autoRangeIncludesZero, autoRangeStickyZero, autoRangeMinimumSize, minimumAxisValue, maximumAxisValue, inverted, autoTickUnitSelection, tickUnit, gridLinesVisible, gridStroke, gridPaint, crosshairVisible, crosshairValue, crosshairStroke, crosshairPaint);
        this.verticalTickLabels = verticalTickLabels;
        this.markerBand = null;
    }

    public boolean getVerticalTickLabels() {
        return this.verticalTickLabels;
    }

    public void setVerticalTickLabels(boolean flag) {
        this.verticalTickLabels = flag;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public double translateValueToJava2D(double value, Rectangle2D dataArea) {
        double axisMin = this.range.getLowerBound();
        double axisMax = this.range.getUpperBound();
        double minX = dataArea.getX();
        double maxX = dataArea.getMaxX();
        if (this.inverted) {
            return maxX - (value - axisMin) / (axisMax - axisMin) * (maxX - minX);
        }
        return minX + (value - axisMin) / (axisMax - axisMin) * (maxX - minX);
    }

    public double translateJava2DtoValue(float java2DValue, Rectangle2D dataArea) {
        double axisMin = this.range.getLowerBound();
        double axisMax = this.range.getUpperBound();
        double plotX = dataArea.getX();
        double plotMaxX = dataArea.getMaxX();
        if (this.inverted) {
            return axisMax - ((double)java2DValue - plotX) / (plotMaxX - plotX) * (axisMax - axisMin);
        }
        return axisMin + ((double)java2DValue - plotX) / (plotMaxX - plotX) * (axisMax - axisMin);
    }

    protected void autoAdjustRange() {
        if (this.plot == null) {
            return;
        }
        if (this.plot instanceof HorizontalValuePlot) {
            double minRange;
            double lower;
            double upper;
            double range;
            HorizontalValuePlot hvp = (HorizontalValuePlot)((Object)this.plot);
            Range r = hvp.getHorizontalDataRange();
            if (r == null) {
                r = new Range(0.0, 1.0);
            }
            if ((range = (upper = r.getUpperBound()) - (lower = r.getLowerBound())) < (minRange = this.autoRangeMinimumSize.doubleValue())) {
                upper = (upper + lower + minRange) / 2.0;
                lower = (upper + lower - minRange) / 2.0;
            }
            if (this.autoRangeIncludesZero) {
                if (this.autoRangeStickyZero) {
                    upper = upper <= 0.0 ? 0.0 : (upper += this.upperMargin * range);
                    lower = lower >= 0.0 ? 0.0 : (lower -= this.lowerMargin * range);
                } else {
                    upper = Math.max(0.0, upper + this.upperMargin * range);
                    lower = Math.min(0.0, lower - this.lowerMargin * range);
                }
            } else if (this.autoRangeStickyZero) {
                upper = upper <= 0.0 ? Math.min(0.0, upper + this.upperMargin * range) : (upper += this.upperMargin * range);
                lower = lower >= 0.0 ? Math.max(0.0, lower - this.lowerMargin * range) : (lower -= this.lowerMargin * range);
            } else {
                upper += this.upperMargin * range;
                lower -= this.lowerMargin * range;
            }
            this.range = new Range(lower, upper);
        }
    }

    public void refreshTicks(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        this.ticks.clear();
        g2.setFont(this.tickLabelFont);
        if (this.autoTickUnitSelection) {
            this.selectAutoTickUnit(g2, drawArea, plotArea);
        }
        double size = this.tickUnit.getSize();
        int count = this.calculateVisibleTickCount();
        double lowestTickValue = this.calculateLowestVisibleTickValue();
        int i = 0;
        while (i < count) {
            double currentTickValue = lowestTickValue + (double)i * size;
            double xx = this.translateValueToJava2D(currentTickValue, plotArea);
            String tickLabel = this.tickUnit.valueToString(currentTickValue);
            Rectangle2D tickLabelBounds = this.tickLabelFont.getStringBounds(tickLabel, g2.getFontRenderContext());
            float x = 0.0f;
            float y = 0.0f;
            if (this.verticalTickLabels) {
                x = (float)(xx + tickLabelBounds.getHeight() / 2.0);
                y = (float)(plotArea.getMaxY() + (double)this.tickLabelInsets.top + tickLabelBounds.getWidth());
            } else {
                x = (float)(xx - tickLabelBounds.getWidth() / 2.0);
                y = (float)(plotArea.getMaxY() + (double)this.tickLabelInsets.top + tickLabelBounds.getHeight());
            }
            Tick tick = new Tick(new Double(currentTickValue), tickLabel, x, y);
            this.ticks.add(tick);
            ++i;
        }
    }

    public void draw(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        if (!this.visible) {
            return;
        }
        double y = drawArea.getMaxY();
        if (this.label != null) {
            g2.setFont(this.labelFont);
            g2.setPaint(this.labelPaint);
            FontRenderContext frc = g2.getFontRenderContext();
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, frc);
            LineMetrics lm = this.labelFont.getLineMetrics(this.label, frc);
            float labelx = (float)(plotArea.getX() + plotArea.getWidth() / 2.0 - labelBounds.getWidth() / 2.0);
            float labely = (float)(y - (double)this.labelInsets.bottom - (double)lm.getDescent() - (double)lm.getLeading());
            y = y - (double)this.labelInsets.bottom - (double)this.labelInsets.top - (double)lm.getHeight();
            g2.drawString(this.label, labelx, labely);
        }
        if (this.markerBand != null) {
            this.markerBand.draw(g2, drawArea, plotArea, 0.0, y -= this.markerBand.getHeight(g2));
        }
        this.refreshTicks(g2, drawArea, plotArea);
        float maxY = (float)plotArea.getMaxY();
        g2.setFont(this.getTickLabelFont());
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float xx = (float)this.translateValueToJava2D(tick.getNumericalValue(), plotArea);
            if (this.tickLabelsVisible) {
                g2.setPaint(this.tickLabelPaint);
                if (this.verticalTickLabels) {
                    RefineryUtilities.drawRotatedString(tick.getText(), g2, tick.getX(), tick.getY(), -1.5707963267948966);
                } else {
                    g2.drawString(tick.getText(), tick.getX(), tick.getY());
                }
            }
            if (this.tickMarksVisible) {
                g2.setStroke(this.getTickMarkStroke());
                Line2D.Float mark = new Line2D.Float(xx, maxY - 2.0f, xx, maxY + 2.0f);
                g2.draw(mark);
            }
            if (!this.gridLinesVisible) continue;
            g2.setStroke(this.gridStroke);
            g2.setPaint(this.gridPaint);
            Line2D.Float gridline = new Line2D.Float(xx, (float)plotArea.getMaxY(), xx, (float)plotArea.getMinY());
            g2.draw(gridline);
        }
    }

    public double reserveHeight(Graphics2D g2, Plot plot, Rectangle2D drawArea) {
        if (!this.visible) {
            return 0.0;
        }
        double labelHeight = 0.0;
        if (this.label != null) {
            LineMetrics metrics = this.labelFont.getLineMetrics(this.label, g2.getFontRenderContext());
            labelHeight = (float)this.labelInsets.top + metrics.getHeight() + (float)this.labelInsets.bottom;
        }
        double markerBandHeight = 0.0;
        if (this.markerBand != null) {
            markerBandHeight = this.markerBand.getHeight(g2);
        }
        double tickLabelHeight = this.tickLabelInsets.top + this.tickLabelInsets.bottom;
        if (this.tickLabelsVisible) {
            g2.setFont(this.tickLabelFont);
            this.refreshTicks(g2, drawArea, drawArea);
            tickLabelHeight += this.getMaxTickLabelHeight(g2, drawArea, this.verticalTickLabels);
        }
        return labelHeight + markerBandHeight + tickLabelHeight;
    }

    public Rectangle2D reserveAxisArea(Graphics2D g2, Plot plot, Rectangle2D drawArea, double reservedWidth) {
        if (!this.visible) {
            return new Rectangle2D.Double(drawArea.getX(), drawArea.getMaxY(), drawArea.getWidth() - reservedWidth, 0.0);
        }
        double labelHeight = 0.0;
        if (this.label != null) {
            LineMetrics metrics = this.labelFont.getLineMetrics(this.label, g2.getFontRenderContext());
            labelHeight = (float)this.labelInsets.top + metrics.getHeight() + (float)this.labelInsets.bottom;
        }
        double markerBandHeight = 0.0;
        if (this.markerBand != null) {
            markerBandHeight = this.markerBand.getHeight(g2);
        }
        double tickLabelHeight = this.tickLabelInsets.top + this.tickLabelInsets.bottom;
        if (this.tickLabelsVisible) {
            g2.setFont(this.tickLabelFont);
            this.refreshTicks(g2, drawArea, drawArea);
            tickLabelHeight += this.getMaxTickLabelHeight(g2, drawArea, this.verticalTickLabels);
        }
        return new Rectangle2D.Double(drawArea.getX(), drawArea.getMaxY(), drawArea.getWidth() - reservedWidth, labelHeight + markerBandHeight + tickLabelHeight);
    }

    private void selectAutoTickUnit(Graphics2D g2, Rectangle2D drawArea, Rectangle2D dataArea) {
        double tickLabelWidth = this.estimateMaximumTickLabelWidth(g2, this.tickUnit);
        double zero = this.translateValueToJava2D(0.0, dataArea);
        TickUnit unit1 = this.standardTickUnits.getCeilingTickUnit(this.tickUnit);
        double x1 = this.translateValueToJava2D(unit1.getSize(), dataArea);
        double unit1Width = Math.abs(x1 - zero);
        double guess = tickLabelWidth / unit1Width * unit1.getSize();
        NumberTickUnit unit2 = (NumberTickUnit)this.standardTickUnits.getCeilingTickUnit(guess);
        double x2 = this.translateValueToJava2D(unit2.getSize(), dataArea);
        double unit2Width = Math.abs(x2 - zero);
        tickLabelWidth = this.estimateMaximumTickLabelWidth(g2, unit2);
        if (tickLabelWidth > unit2Width) {
            unit2 = (NumberTickUnit)this.standardTickUnits.getLargerTickUnit(unit2);
        }
        this.tickUnit = unit2;
    }

    private double estimateMaximumTickLabelWidth(Graphics2D g2, TickUnit tickUnit) {
        double result = this.tickLabelInsets.left + this.tickLabelInsets.right;
        FontRenderContext frc = g2.getFontRenderContext();
        if (this.verticalTickLabels) {
            result += this.tickLabelFont.getStringBounds("0", frc).getHeight();
        } else {
            double lower = this.range.getLowerBound();
            double upper = this.range.getUpperBound();
            String lowerStr = tickUnit.valueToString(lower);
            String upperStr = tickUnit.valueToString(upper);
            double w1 = this.tickLabelFont.getStringBounds(lowerStr, frc).getWidth();
            double w2 = this.tickLabelFont.getStringBounds(upperStr, frc).getWidth();
            result += Math.max(w1, w2);
        }
        return result;
    }

    private double getMaxTickLabelHeight(Graphics2D g2, Rectangle2D drawArea, boolean vertical) {
        Font font = this.getTickLabelFont();
        g2.setFont(font);
        FontRenderContext frc = g2.getFontRenderContext();
        double maxHeight = 0.0;
        if (vertical) {
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D labelBounds = font.getStringBounds(tick.getText(), frc);
                if (!(labelBounds.getWidth() > maxHeight)) continue;
                maxHeight = labelBounds.getWidth();
            }
        } else {
            LineMetrics metrics = font.getLineMetrics("Sample", frc);
            maxHeight = metrics.getHeight();
        }
        return maxHeight;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof HorizontalValuePlot;
    }

    public HorizontalMarkerAxisBand getMarkerBand() {
        return this.markerBand;
    }

    public void setMarkerBand(HorizontalMarkerAxisBand band) {
        this.markerBand = band;
        this.notifyListeners(new AxisChangeEvent(this));
    }
}

