/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.data.Range;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class HorizontalLogarithmicAxis
extends HorizontalNumberAxis {
    public static final double LOG10_VALUE = Math.log(10.0);
    protected final boolean allowNegativesFlag;
    protected boolean smallLogFlag = false;
    protected final DecimalFormat numberFormatterObj = new DecimalFormat("0.00000");

    public HorizontalLogarithmicAxis() {
        this(null);
    }

    public HorizontalLogarithmicAxis(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 1.0, 10.0);
        this.autoRange = true;
    }

    public HorizontalLogarithmicAxis(String label, Font labelFont, double minimumAxisValue, double maximumAxisValue) {
        this(label, labelFont, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, true, AxisConstants.DEFAULT_TICK_STROKE, false, true, true, NumberAxis.DEFAULT_MINIMUM_AUTO_RANGE, minimumAxisValue, maximumAxisValue, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT, false);
    }

    public HorizontalLogarithmicAxis(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean tickLabelsVisible, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean verticalTickLabels, boolean tickMarksVisible, Stroke tickMarkStroke, boolean autoRange, boolean autoRangeIncludesZero, boolean autoRangeStickyZero, Number autoRangeMinimum, double minimumAxisValue, double maximumAxisValue, boolean inverted, boolean autoTickUnitSelection, NumberTickUnit tickUnit, boolean gridLinesVisible, Stroke gridStroke, Paint gridPaint, boolean crosshairVisible, double crosshairValue, Stroke crosshairStroke, Paint crosshairPaint, boolean allowNegativesFlag) {
        super(label, labelFont, labelPaint, labelInsets, tickLabelsVisible, tickLabelFont, tickLabelPaint, tickLabelInsets, verticalTickLabels, tickMarksVisible, tickMarkStroke, autoRange, autoRangeIncludesZero, autoRangeStickyZero, autoRangeMinimum, minimumAxisValue, maximumAxisValue, inverted, autoTickUnitSelection, tickUnit, gridLinesVisible, gridStroke, gridPaint, crosshairVisible, crosshairValue, crosshairStroke, crosshairPaint);
        this.allowNegativesFlag = allowNegativesFlag;
        if (!autoRange) {
            this.setupSmallLogFlag();
        }
    }

    public void setRange(Range range) {
        super.setRange(range);
        this.setupSmallLogFlag();
    }

    protected void setupSmallLogFlag() {
        double lowerVal = this.range.getLowerBound();
        this.smallLogFlag = !this.allowNegativesFlag && lowerVal < 10.0 && lowerVal > 0.0;
    }

    public double translateValueToJava2D(double value, Rectangle2D plotArea) {
        double axisMin = this.switchedLog10(this.range.getLowerBound());
        double axisMax = this.switchedLog10(this.range.getUpperBound());
        double maxX = plotArea.getMaxX();
        double minX = plotArea.getMinX();
        value = this.switchedLog10(value);
        if (this.inverted) {
            return maxX - (value - axisMin) / (axisMax - axisMin) * (maxX - minX);
        }
        return minX + (value - axisMin) / (axisMax - axisMin) * (maxX - minX);
    }

    public double translateJava2DtoValue(float java2DValue, Rectangle2D plotArea) {
        double axisMin = this.switchedLog10(this.range.getLowerBound());
        double axisMax = this.switchedLog10(this.range.getUpperBound());
        double plotX = plotArea.getX();
        double plotMaxX = plotArea.getMaxX();
        if (this.inverted) {
            return axisMax - Math.pow(10.0, ((double)java2DValue - plotX) / (plotMaxX - plotX) * (axisMax - axisMin));
        }
        return axisMin + Math.pow(10.0, ((double)java2DValue - plotX) / (plotMaxX - plotX) * (axisMax - axisMin));
    }

    public void autoAdjustRange() {
        if (this.plot instanceof HorizontalValuePlot) {
            HorizontalValuePlot hvp = (HorizontalValuePlot)((Object)this.plot);
            Range r = hvp.getHorizontalDataRange();
            if (r == null) {
                r = new Range(0.0, 1.0);
            }
            double lower = this.computeLogFloor(r.getLowerBound());
            if (!this.allowNegativesFlag && lower >= 0.0 && lower < 1.0E-25) {
                lower = r.getLowerBound();
            }
            double upper = r.getUpperBound();
            if (!this.allowNegativesFlag && upper < 1.0 && upper > 0.0 && lower > 0.0) {
                double expVal = Math.log(upper) / LOG10_VALUE;
                expVal = Math.ceil(-expVal + 0.001);
                upper = (expVal = Math.pow(10.0, expVal)) > 0.0 ? Math.ceil(upper * expVal) / expVal : Math.ceil(upper);
            } else {
                upper = Math.ceil(upper);
            }
            double minRange = this.autoRangeMinimumSize.doubleValue();
            if (upper - lower < minRange) {
                upper = (upper + lower + minRange) / 2.0;
                lower = (upper + lower - minRange) / 2.0;
            }
            this.range = new Range(lower, upper);
        }
        this.setupSmallLogFlag();
    }

    private double computeLogCeil(double upper) {
        double logCeil;
        if (upper > 10.0) {
            logCeil = Math.log(upper) / LOG10_VALUE;
            logCeil = Math.ceil(logCeil);
            logCeil = Math.pow(10.0, logCeil);
        } else if (upper < -10.0) {
            logCeil = Math.log(-upper) / LOG10_VALUE;
            logCeil = Math.ceil(-logCeil);
            logCeil = -Math.pow(10.0, -logCeil);
        } else {
            logCeil = Math.ceil(upper);
        }
        return logCeil;
    }

    private double computeLogFloor(double lower) {
        double logFloor;
        if (lower > 10.0) {
            logFloor = Math.log(lower) / LOG10_VALUE;
            logFloor = Math.floor(logFloor);
            logFloor = Math.pow(10.0, logFloor);
        } else if (lower < -10.0) {
            logFloor = Math.log(-lower) / LOG10_VALUE;
            logFloor = Math.floor(-logFloor);
            logFloor = -Math.pow(10.0, -logFloor);
        } else {
            logFloor = Math.floor(lower);
        }
        return logFloor;
    }

    public void refreshTicks(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        this.ticks.clear();
        double lowerBoundVal = this.range.getLowerBound();
        if (this.smallLogFlag && lowerBoundVal < 1.0E-25) {
            lowerBoundVal = 1.0E-25;
        }
        double upperBoundVal = this.range.getUpperBound();
        int iBegCount = (int)Math.rint(this.switchedLog10(lowerBoundVal));
        int iEndCount = (int)Math.rint(this.switchedLog10(upperBoundVal));
        boolean zeroTickFlag = false;
        int i = iBegCount;
        while (i <= iEndCount) {
            int j = 0;
            while (j < 10) {
                String tickLabel;
                double currentTickValue;
                if (this.smallLogFlag) {
                    currentTickValue = Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j;
                    if (i < 0 && currentTickValue > 0.0 && currentTickValue < 1.0) {
                        if (j == 0 || i > -4 && j < 2 || currentTickValue >= upperBoundVal) {
                            this.numberFormatterObj.setMaximumFractionDigits(-i);
                            tickLabel = this.numberFormatterObj.format(currentTickValue);
                        } else {
                            tickLabel = "";
                        }
                    } else {
                        tickLabel = j < 5 || currentTickValue >= upperBoundVal ? this.tickUnit.valueToString(currentTickValue) : "";
                    }
                } else {
                    if (zeroTickFlag) {
                        --j;
                    }
                    double d = currentTickValue = i >= 0 ? Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j : -(Math.pow(10.0, -i) - Math.pow(10.0, -i - 1) * (double)j);
                    if (!zeroTickFlag) {
                        if (Math.abs(currentTickValue - 1.0) < 1.0E-4 && lowerBoundVal <= 0.0 && upperBoundVal >= 0.0) {
                            currentTickValue = 0.0;
                            zeroTickFlag = true;
                        }
                    } else {
                        zeroTickFlag = false;
                    }
                    tickLabel = this.tickUnit.valueToString(currentTickValue);
                }
                double xx = this.translateValueToJava2D(currentTickValue, plotArea);
                Rectangle2D tickLabelBounds = this.tickLabelFont.getStringBounds(tickLabel, g2.getFontRenderContext());
                float x = 0.0f;
                float y = 0.0f;
                if (this.verticalTickLabels) {
                    x = (float)(xx + tickLabelBounds.getHeight() / 2.0);
                    y = (float)(plotArea.getMaxY() + (double)this.tickLabelInsets.top + tickLabelBounds.getWidth());
                } else {
                    x = (float)(xx - tickLabelBounds.getWidth() / 2.0);
                    y = (float)(plotArea.getMaxY() + (double)this.tickLabelInsets.top + tickLabelBounds.getHeight());
                }
                Tick tick = new Tick(new Double(currentTickValue), tickLabel, x, y);
                this.ticks.add(tick);
                if (currentTickValue > upperBoundVal) {
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    protected double switchedLog10(double val) {
        return this.smallLogFlag ? Math.log(val) / LOG10_VALUE : this.adjustedLog10(val);
    }

    public double adjustedLog10(double val) {
        boolean negFlag = val < 0.0;
        if (negFlag) {
            val = -val;
        }
        if (val < 10.0) {
            val += (10.0 - val) / 10.0;
        }
        return negFlag ? -(Math.log(val) / LOG10_VALUE) : Math.log(val) / LOG10_VALUE;
    }
}

