/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.BarRenderer;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.IntervalCategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class HorizontalIntervalBarRenderer
extends BarRenderer
implements CategoryItemRenderer {
    public HorizontalIntervalBarRenderer() {
        this(new StandardCategoryToolTipGenerator());
    }

    public HorizontalIntervalBarRenderer(CategoryToolTipGenerator toolTipGenerator) {
        super(toolTipGenerator);
    }

    public void initialise(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, ChartRenderingInfo info) {
        super.initialise(g2, dataArea, plot, axis, data, info);
        this.calculateCategoryAndItemSpans(g2, dataArea, plot, data, dataArea.getHeight());
    }

    public boolean hasItemGaps() {
        return false;
    }

    public int barWidthsPerCategory(CategoryDataset data) {
        return data.getSeriesCount();
    }

    public void drawRangeMarker(Graphics2D g2, CategoryPlot plot, ValueAxis axis, Marker marker, Rectangle2D axisDataArea, Shape dataClipRegion) {
        double value = marker.getValue();
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        double x = axis.translateValueToJava2D(marker.getValue(), axisDataArea);
        Line2D.Double line = new Line2D.Double(x, axisDataArea.getMinY(), x, axisDataArea.getMaxY());
        g2.setPaint(marker.getOutlinePaint());
        g2.draw(line);
    }

    public void drawCategoryItem(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, int series, Object category, int categoryIndex, Object previousCategory) {
        IntervalCategoryDataset intervalData = (IntervalCategoryDataset)data;
        Number value0 = intervalData.getStartValue(series, category);
        double translatedValue0 = axis.translateValueToJava2D(value0.doubleValue(), dataArea);
        Number value1 = intervalData.getEndValue(series, category);
        double translatedValue1 = axis.translateValueToJava2D(value1.doubleValue(), dataArea);
        if (translatedValue1 < translatedValue0) {
            double temp = translatedValue1;
            translatedValue1 = translatedValue0;
            translatedValue0 = temp;
        }
        double rectY = dataArea.getY() + dataArea.getHeight() * plot.getIntroGapPercent();
        int categories = data.getCategoryCount();
        int seriesCount = data.getSeriesCount();
        if (categories > 1) {
            rectY = rectY + (double)categoryIndex * this.categorySpan / (double)categories + (double)categoryIndex * this.categoryGapSpan / (double)(categories - 1) + (double)series * this.itemSpan / (double)(categories * seriesCount);
            if (seriesCount > 1) {
                rectY += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
            }
        } else {
            rectY += (double)series * this.itemSpan / (double)(categories * seriesCount);
            if (seriesCount > 1) {
                rectY += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
            }
        }
        double rectWidth = Math.abs(translatedValue1 - translatedValue0);
        double rectHeight = this.itemWidth;
        Rectangle2D.Double bar = new Rectangle2D.Double(translatedValue0, rectY, rectWidth, rectHeight);
        Paint seriesPaint = plot.getSeriesPaint(series);
        g2.setPaint(seriesPaint);
        g2.fill(bar);
        if (this.itemWidth > 3.0) {
            g2.setStroke(plot.getSeriesStroke(series));
            g2.setPaint(plot.getSeriesOutlinePaint(series));
            g2.draw(bar);
        }
    }
}

