/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.DateAxis;
import com.jrefinery.chart.DateUnit;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.DateRange;
import com.jrefinery.data.Range;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class HorizontalDateAxis
extends DateAxis
implements HorizontalAxis {
    protected boolean verticalTickLabels;

    public HorizontalDateAxis() {
        this(null, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_STROKE, true, new DateRange(), true, new DateUnit(5, 1), new SimpleDateFormat(), true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, DateAxis.DEFAULT_CROSSHAIR_DATE, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    public HorizontalDateAxis(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, true, AxisConstants.DEFAULT_TICK_STROKE, true, new DateRange(), true, new DateUnit(5, 1), new SimpleDateFormat(), true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, DateAxis.DEFAULT_CROSSHAIR_DATE, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    public HorizontalDateAxis(String label, Font labelFont, Range range) {
        this(label, labelFont, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_STROKE, true, range, true, new DateUnit(5, 1), new SimpleDateFormat(), true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, DateAxis.DEFAULT_CROSSHAIR_DATE, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    public HorizontalDateAxis(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean showTickLabels, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean verticalTickLabels, boolean showTickMarks, Stroke tickMarkStroke, boolean autoRange, Range range, boolean autoUnits, DateUnit tickUnits, SimpleDateFormat tickLabelFormatter, boolean gridVisible, Stroke gridStroke, Paint gridPaint, boolean crosshairVisible, Date crosshairDate, Stroke crosshairStroke, Paint crosshairPaint) {
        super(label, labelFont, labelPaint, labelInsets, showTickLabels, tickLabelFont, tickLabelPaint, tickLabelInsets, showTickMarks, tickMarkStroke, autoRange, range, autoUnits, tickUnits, tickLabelFormatter, gridVisible, gridStroke, gridPaint, crosshairVisible, crosshairDate, crosshairStroke, crosshairPaint);
        this.verticalTickLabels = verticalTickLabels;
    }

    public boolean getVerticalTickLabels() {
        return this.verticalTickLabels;
    }

    public void setVerticalTickLabels(boolean flag) {
        this.verticalTickLabels = flag;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public double translateDateToJava2D(Date date, Rectangle2D dataArea) {
        double value = date.getTime();
        double axisMin = this.range.getLowerBound();
        double axisMax = this.range.getUpperBound();
        double plotX = dataArea.getX();
        double plotMaxX = dataArea.getMaxX();
        return plotX + (value - axisMin) / (axisMax - axisMin) * (plotMaxX - plotX);
    }

    public double translateValueToJava2D(double value, Rectangle2D dataArea) {
        double axisMin = this.range.getLowerBound();
        double axisMax = this.range.getUpperBound();
        double plotX = dataArea.getX();
        double plotMaxX = dataArea.getMaxX();
        return plotX + (value - axisMin) / (axisMax - axisMin) * (plotMaxX - plotX);
    }

    public double translateJava2DtoValue(float java2DValue, Rectangle2D dataArea) {
        double axisMin = this.range.getLowerBound();
        double axisMax = this.range.getUpperBound();
        double plotX = dataArea.getX();
        double plotMaxX = dataArea.getMaxX();
        double result = axisMin + ((double)java2DValue - plotX) / (plotMaxX - plotX) * (axisMax - axisMin);
        return result;
    }

    protected void autoAdjustRange() {
        if (this.plot == null) {
            return;
        }
        if (this.plot instanceof HorizontalValuePlot) {
            long lower;
            HorizontalValuePlot hvp = (HorizontalValuePlot)((Object)this.plot);
            Range r = hvp.getHorizontalDataRange();
            if (r == null) {
                r = new DateRange();
            }
            long upper = (long)r.getUpperBound();
            if (this.fixedAutoRange > 0.0) {
                lower = upper - (long)this.fixedAutoRange;
            } else {
                lower = (long)r.getLowerBound();
                long range = upper - lower;
                upper += range / 20L;
                lower -= range / 20L;
            }
            this.range = new DateRange(new Date(lower), new Date(upper));
        }
    }

    public void refreshTicks(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        this.ticks.clear();
        g2.setFont(this.tickLabelFont);
        FontRenderContext frc = g2.getFontRenderContext();
        if (this.autoTickUnitSelection) {
            this.calculateAutoTickUnits(g2, drawArea, plotArea);
        }
        Rectangle2D labelBounds = null;
        Date tickDate = this.calculateLowestVisibleTickValue(this.tickUnit);
        Date upperDate = this.getMaximumDate();
        while (tickDate.before(upperDate)) {
            double xx = this.translateDateToJava2D(tickDate, plotArea);
            String tickLabel = this.tickLabelFormatter.format(tickDate);
            labelBounds = this.tickLabelFont.getStringBounds(tickLabel, g2.getFontRenderContext());
            LineMetrics metrics = this.tickLabelFont.getLineMetrics(tickLabel, frc);
            float x = 0.0f;
            float y = 0.0f;
            if (this.verticalTickLabels) {
                x = (float)(xx + labelBounds.getHeight() / 2.0 - (double)metrics.getDescent());
                y = (float)(plotArea.getMaxY() + (double)this.tickLabelInsets.top + labelBounds.getWidth());
            } else {
                x = (float)(xx - labelBounds.getWidth() / 2.0);
                y = (float)(plotArea.getMaxY() + (double)this.tickLabelInsets.top + labelBounds.getHeight());
            }
            Tick tick = new Tick(tickDate, tickLabel, x, y);
            this.ticks.add(tick);
            tickDate = this.tickUnit.addToDate(tickDate);
        }
    }

    public void draw(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        if (!this.visible) {
            return;
        }
        if (this.label != null) {
            g2.setFont(this.labelFont);
            g2.setPaint(this.labelPaint);
            FontRenderContext frc = g2.getFontRenderContext();
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, frc);
            LineMetrics lm = this.labelFont.getLineMetrics(this.label, frc);
            float labelx = (float)(plotArea.getX() + plotArea.getWidth() / 2.0 - labelBounds.getWidth() / 2.0);
            float labely = (float)(drawArea.getMaxY() - (double)this.labelInsets.bottom - (double)lm.getDescent() - (double)lm.getLeading());
            g2.drawString(this.label, labelx, labely);
        }
        this.refreshTicks(g2, drawArea, plotArea);
        float maxY = (float)plotArea.getMaxY();
        g2.setFont(this.getTickLabelFont());
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float xx = (float)this.translateValueToJava2D(tick.getNumericalValue(), plotArea);
            if (this.tickLabelsVisible) {
                g2.setPaint(this.tickLabelPaint);
                if (this.verticalTickLabels) {
                    RefineryUtilities.drawRotatedString(tick.getText(), g2, tick.getX(), tick.getY(), -1.5707963267948966);
                } else {
                    g2.drawString(tick.getText(), tick.getX(), tick.getY());
                }
            }
            if (this.tickMarksVisible) {
                g2.setStroke(this.getTickMarkStroke());
                Line2D.Float mark = new Line2D.Float(xx, maxY - 2.0f, xx, maxY + 2.0f);
                g2.draw(mark);
            }
            if (!this.gridLinesVisible) continue;
            g2.setStroke(this.gridStroke);
            g2.setPaint(this.gridPaint);
            Line2D.Float gridline = new Line2D.Float(xx, (float)plotArea.getMaxY(), xx, (float)plotArea.getMinY());
            g2.draw(gridline);
        }
    }

    public double reserveHeight(Graphics2D g2, Plot plot, Rectangle2D drawArea) {
        if (!this.visible) {
            return 0.0;
        }
        double labelHeight = 0.0;
        if (this.label != null) {
            LineMetrics metrics = this.labelFont.getLineMetrics(this.label, g2.getFontRenderContext());
            labelHeight = (float)this.labelInsets.top + metrics.getHeight() + (float)this.labelInsets.bottom;
        }
        double tickLabelHeight = this.tickLabelInsets.top + this.tickLabelInsets.bottom;
        if (this.tickLabelsVisible) {
            g2.setFont(this.tickLabelFont);
            this.refreshTicks(g2, drawArea, drawArea);
            tickLabelHeight += this.getMaxTickLabelHeight(g2, drawArea, this.verticalTickLabels);
        }
        return labelHeight + tickLabelHeight;
    }

    public Rectangle2D reserveAxisArea(Graphics2D g2, Plot plot, Rectangle2D drawArea, double reservedWidth) {
        if (!this.visible) {
            return new Rectangle2D.Double(drawArea.getX(), drawArea.getMaxY(), drawArea.getWidth() - reservedWidth, 0.0);
        }
        LineMetrics metrics = this.labelFont.getLineMetrics(this.label, g2.getFontRenderContext());
        double labelHeight = (float)this.labelInsets.top + metrics.getHeight() + (float)this.labelInsets.bottom;
        double tickLabelHeight = this.tickLabelInsets.top + this.tickLabelInsets.bottom;
        if (this.tickLabelsVisible) {
            g2.setFont(this.tickLabelFont);
            this.refreshTicks(g2, drawArea, drawArea);
            tickLabelHeight += this.getMaxTickLabelHeight(g2, drawArea, this.verticalTickLabels);
        }
        return new Rectangle2D.Double(drawArea.getX(), drawArea.getMaxY(), drawArea.getWidth() - reservedWidth, labelHeight + tickLabelHeight);
    }

    private void calculateAutoTickUnits(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        int index = this.findAxisMagnitudeIndex();
        boolean labelsFit = true;
        while (labelsFit && index > 0) {
            labelsFit = this.tickLabelsFit(--index, g2, drawArea, plotArea);
        }
        this.autoTickIndex = labelsFit ? index : Math.min(index + 1, standardTickUnitMagnitudes.length);
        this.tickLabelFormatter.applyPattern(standardTickFormats[this.autoTickIndex]);
        this.tickUnit = new DateUnit(standardTickUnits[this.autoTickIndex][0], standardTickUnits[this.autoTickIndex][1]);
    }

    private boolean tickLabelsFit(int index, Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DateAxis.standardTickFormats[index]);
        DateUnit units = new DateUnit(standardTickUnits[index][0], standardTickUnits[index][1]);
        double lastLabelExtent = Double.NEGATIVE_INFINITY;
        boolean labelsFit = true;
        Date tickDate = this.calculateLowestVisibleTickValue(units);
        Date upperDate = this.getMaximumDate();
        while (tickDate.before(upperDate) && labelsFit) {
            double labelExtent;
            double xx = this.translateDateToJava2D(tickDate, plotArea);
            String tickLabel = dateFormatter.format(tickDate);
            Rectangle2D tickLabelBounds = this.tickLabelFont.getStringBounds(tickLabel, g2.getFontRenderContext());
            if (this.verticalTickLabels) {
                labelExtent = xx - tickLabelBounds.getHeight() / 2.0;
                if (labelExtent < lastLabelExtent) {
                    labelsFit = false;
                }
                lastLabelExtent = xx + tickLabelBounds.getHeight() / 2.0;
            } else {
                labelExtent = xx - tickLabelBounds.getWidth() / 2.0;
                if (labelExtent < lastLabelExtent) {
                    labelsFit = false;
                }
                lastLabelExtent = xx + tickLabelBounds.getWidth() / 2.0;
            }
            tickDate = units.addToDate(tickDate);
        }
        return labelsFit;
    }

    private double getMaxTickLabelHeight(Graphics2D g2, Rectangle2D drawArea, boolean vertical) {
        Font font = this.getTickLabelFont();
        g2.setFont(font);
        FontRenderContext frc = g2.getFontRenderContext();
        double maxHeight = 0.0;
        if (vertical) {
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D labelBounds = font.getStringBounds(tick.getText(), frc);
                if (!(labelBounds.getWidth() > maxHeight)) continue;
                maxHeight = labelBounds.getWidth();
            }
        } else {
            LineMetrics metrics = font.getLineMetrics("Sample", frc);
            maxHeight = metrics.getHeight();
        }
        return maxHeight;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof HorizontalValuePlot;
    }
}

