/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalCategoryAxis;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.Range;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class HorizontalCategoryPlot
extends CategoryPlot
implements HorizontalValuePlot {
    public HorizontalCategoryPlot(CategoryDataset data, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryItemRenderer renderer) {
        this(data, domainAxis, rangeAxis, renderer, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 0.05, 0.05, 0.2, 0.15);
    }

    public HorizontalCategoryPlot(CategoryDataset data, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryItemRenderer renderer, Insets insets, Paint backgroundPaint, Image backgroundImage, float backgroundAlpha, Stroke outlineStroke, Paint outlinePaint, float alpha, double introGapPercent, double trailGapPercent, double categoryGapPercent, double itemGapPercent) {
        super(data, domainAxis, rangeAxis, renderer, insets, backgroundPaint, backgroundImage, backgroundAlpha, outlineStroke, outlinePaint, alpha, introGapPercent, trailGapPercent, categoryGapPercent, itemGapPercent);
    }

    public CategoryDataset getCategoryDataset() {
        return (CategoryDataset)this.dataset;
    }

    public double getCategoryCoordinate(int category, Rectangle2D area) {
        double result = area.getY() + area.getHeight() * this.introGapPercent;
        int categoryCount = this.getCategoryDataset().getCategoryCount();
        if (categoryCount > 1) {
            double categorySpan = area.getHeight() * (1.0 - this.introGapPercent - this.trailGapPercent - this.categoryGapsPercent);
            double categoryGapSpan = area.getHeight() * this.categoryGapsPercent;
            result = result + ((double)category + 0.5) * (categorySpan / (double)categoryCount) + (double)category * (categoryGapSpan / (double)(categoryCount - 1));
        } else {
            result += ((double)category + 0.5) * area.getHeight() * (1.0 - this.introGapPercent - this.trailGapPercent);
        }
        return result;
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis instanceof HorizontalAxis && axis instanceof ValueAxis;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalCategoryAxis;
    }

    public boolean isCompatibleDomainAxis(CategoryAxis axis) {
        if (axis == null) {
            return true;
        }
        return this.isCompatibleVerticalAxis(axis);
    }

    public boolean isCompatibleRangeAxis(ValueAxis axis) {
        if (axis == null) {
            return true;
        }
        return this.isCompatibleHorizontalAxis(axis);
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, ChartRenderingInfo info) {
        if (info != null) {
            info.setPlotArea(plotArea);
        }
        if (this.insets != null) {
            plotArea.setRect(plotArea.getX() + (double)this.insets.left, plotArea.getY() + (double)this.insets.top, plotArea.getWidth() - (double)this.insets.left - (double)this.insets.right, plotArea.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        if (plotArea.getWidth() >= 10.0 && plotArea.getHeight() >= 10.0) {
            Rectangle2D axisArea = this.renderer.getAxisArea(plotArea);
            VerticalAxis vAxis = (VerticalAxis)((Object)this.getDomainAxis());
            HorizontalAxis hAxis = (HorizontalAxis)((Object)this.getRangeAxis());
            double vAxisAreaWidth = vAxis.reserveWidth(g2, this, axisArea);
            Rectangle2D hAxisArea = hAxis.reserveAxisArea(g2, this, axisArea, vAxisAreaWidth);
            Rectangle2D.Double dataArea = new Rectangle2D.Double(plotArea.getX() + vAxisAreaWidth, plotArea.getY(), plotArea.getWidth() - vAxisAreaWidth, plotArea.getHeight() - hAxisArea.getHeight());
            Rectangle2D.Double axisDataArea = new Rectangle2D.Double(axisArea.getX() + vAxisAreaWidth, axisArea.getY(), axisArea.getWidth() - vAxisAreaWidth, axisArea.getHeight() - hAxisArea.getHeight());
            if (info != null) {
                info.setDataArea(dataArea);
            }
            Shape dataClipRegion = this.renderer.getDataClipRegion(dataArea);
            this.renderer.drawPlotBackground(g2, this, axisDataArea, dataClipRegion);
            Iterator iterator = this.markers.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                this.renderer.drawRangeMarker(g2, this, this.getRangeAxis(), marker, axisDataArea, dataClipRegion);
            }
            this.getDomainAxis().draw(g2, axisArea, axisDataArea);
            this.getRangeAxis().draw(g2, axisArea, axisDataArea);
            this.render(g2, axisDataArea, info, dataClipRegion);
        }
    }

    public void render(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, Shape backgroundPlotArea) {
        CategoryDataset data = this.getCategoryDataset();
        if (data != null) {
            Shape savedClip = g2.getClip();
            g2.clip(dataArea);
            Composite originalComposite = g2.getComposite();
            AlphaComposite newComposite = AlphaComposite.getInstance(3, this.foregroundAlpha);
            g2.setComposite(newComposite);
            int seriesCount = data.getSeriesCount();
            this.renderer.initialise(g2, dataArea, this, this.getRangeAxis(), data, info);
            int categoryIndex = 0;
            Object previousCategory = null;
            Iterator iterator = data.getCategories().iterator();
            while (iterator.hasNext()) {
                Object category = iterator.next();
                int series = 0;
                while (series < seriesCount) {
                    this.renderer.drawCategoryItem(g2, dataArea, this, this.getRangeAxis(), data, series, category, categoryIndex, previousCategory);
                    ++series;
                }
                ++categoryIndex;
                previousCategory = category;
            }
            ValueAxis hva = this.getRangeAxis();
            if (hva.isCrosshairVisible()) {
                this.drawVerticalLine(g2, dataArea, hva.getCrosshairValue(), hva.getCrosshairStroke(), hva.getCrosshairPaint());
            }
            g2.setClip(savedClip);
            g2.setComposite(originalComposite);
        }
    }

    public String getPlotType() {
        return "Horizontal Category Plot";
    }

    public Range getHorizontalDataRange() {
        Range result = null;
        CategoryDataset data = this.getCategoryDataset();
        if (data != null) {
            result = this.renderer != null && this.renderer.isStacked() ? DatasetUtilities.getStackedRangeExtent(data) : DatasetUtilities.getRangeExtent(data);
        }
        return result;
    }

    public ValueAxis getHorizontalValueAxis() {
        return this.rangeAxis;
    }

    public void handleClick(int x, int y, ChartRenderingInfo info) {
        ValueAxis hva = this.getRangeAxis();
        double hvalue = hva.translateJava2DtoValue(x, info.getDataArea());
        hva.setAnchorValue(hvalue);
        hva.setCrosshairValue(hvalue);
    }

    private void drawVerticalLine(Graphics2D g2, Rectangle2D dataArea, double value, Stroke stroke, Paint paint) {
        double xx = this.getRangeAxis().translateValueToJava2D(value, dataArea);
        Line2D.Double line = new Line2D.Double(xx, dataArea.getMinY(), xx, dataArea.getMaxY());
        g2.setStroke(stroke);
        g2.setPaint(paint);
        g2.draw(line);
    }
}

