/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.VerticalCategoryPlot;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;

public class HorizontalCategoryAxis
extends CategoryAxis
implements HorizontalAxis {
    protected boolean verticalCategoryLabels;
    private int tickHeight;

    public HorizontalCategoryAxis() {
        this(null, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, false, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, AxisConstants.DEFAULT_TICK_STROKE);
    }

    public HorizontalCategoryAxis(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, false, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, AxisConstants.DEFAULT_TICK_STROKE);
    }

    public HorizontalCategoryAxis(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean categoryLabelsVisible, boolean verticalCategoryLabels, Font categoryLabelFont, Paint categoryLabelPaint, Insets categoryLabelInsets, boolean tickMarksVisible, Stroke tickMarkStroke) {
        super(label, labelFont, labelPaint, labelInsets, categoryLabelsVisible, categoryLabelFont, categoryLabelPaint, categoryLabelInsets, tickMarksVisible, tickMarkStroke);
        this.verticalCategoryLabels = verticalCategoryLabels;
    }

    public boolean getVerticalCategoryLabels() {
        return this.verticalCategoryLabels;
    }

    public void setVerticalCategoryLabels(boolean flag) {
        if (this.verticalCategoryLabels != flag) {
            this.verticalCategoryLabels = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void draw(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        if (!this.visible) {
            return;
        }
        if (this.label != null) {
            g2.setFont(this.labelFont);
            g2.setPaint(this.labelPaint);
            FontRenderContext frc = g2.getFontRenderContext();
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, frc);
            LineMetrics lm = this.labelFont.getLineMetrics(this.label, frc);
            float labelx = (float)(plotArea.getX() + plotArea.getWidth() / 2.0 - labelBounds.getWidth() / 2.0);
            float labely = (float)(drawArea.getMaxY() - (double)this.labelInsets.bottom - (double)lm.getDescent() - (double)lm.getLeading());
            g2.drawString(this.label, labelx, labely);
        }
        if (this.tickLabelsVisible) {
            g2.setFont(this.tickLabelFont);
            g2.setPaint(this.tickLabelPaint);
            this.refreshTicks(g2, drawArea, plotArea);
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj instanceof Tick) {
                    Tick tick = (Tick)obj;
                    if (this.verticalCategoryLabels) {
                        RefineryUtilities.drawRotatedString(tick.getText(), g2, tick.getX(), tick.getY(), -1.5707963267948966);
                        continue;
                    }
                    g2.drawString(tick.getText(), tick.getX(), tick.getY());
                    continue;
                }
                Tick[] ts = (Tick[])obj;
                int i = 0;
                while (i < ts.length) {
                    g2.drawString(ts[i].getText(), ts[i].getX(), ts[i].getY());
                    ++i;
                }
            }
        }
    }

    public void refreshTicks(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        this.tickHeight = 1;
        this.ticks.clear();
        CategoryPlot categoryPlot = (CategoryPlot)this.plot;
        CategoryDataset data = categoryPlot.getCategoryDataset();
        if (data != null) {
            FontRenderContext frc = g2.getFontRenderContext();
            Font font = this.getTickLabelFont();
            g2.setFont(font);
            int categoryIndex = 0;
            float maxWidth = (float)((plotArea.getWidth() + plotArea.getX()) / (double)data.getCategoryCount()) * 0.9f;
            float xx = 0.0f;
            float yy = 0.0f;
            Iterator iterator = data.getCategories().iterator();
            while (iterator.hasNext()) {
                Object category = iterator.next();
                String label = category.toString();
                Rectangle2D labelBounds = font.getStringBounds(label, frc);
                LineMetrics metrics = font.getLineMetrics(label, frc);
                float catX = (float)categoryPlot.getCategoryCoordinate(categoryIndex, plotArea);
                if (this.verticalCategoryLabels) {
                    xx = (float)((double)catX + labelBounds.getHeight() / 2.0 - (double)metrics.getDescent());
                    yy = (float)(plotArea.getMaxY() + (double)this.tickLabelInsets.top + labelBounds.getWidth());
                    this.ticks.add(new Tick(category, label, xx, yy));
                } else if (labelBounds.getWidth() > (double)maxWidth) {
                    String[] labels = this.breakLine(label, (int)maxWidth, frc);
                    Tick[] ts = new Tick[labels.length];
                    int i = 0;
                    while (i < labels.length) {
                        labelBounds = font.getStringBounds(labels[i], frc);
                        xx = (float)((double)catX - labelBounds.getWidth() / 2.0);
                        yy = (float)(plotArea.getMaxY() + (double)this.tickLabelInsets.top + (double)((float)(i + 1) * (metrics.getHeight() - metrics.getDescent())));
                        ts[i] = new Tick(category, labels[i], xx, yy);
                        ++i;
                    }
                    if (labels.length > this.tickHeight) {
                        this.tickHeight = labels.length;
                    }
                    this.ticks.add(ts);
                } else {
                    xx = (float)((double)catX - labelBounds.getWidth() / 2.0);
                    yy = (float)(plotArea.getMaxY() + (double)this.tickLabelInsets.top + (double)metrics.getHeight() - (double)metrics.getDescent());
                    this.ticks.add(new Tick(category, label, xx, yy));
                }
                ++categoryIndex;
            }
        }
    }

    public double reserveHeight(Graphics2D g2, Plot plot, Rectangle2D drawArea) {
        if (!this.visible) {
            return 0.0;
        }
        double labelHeight = 0.0;
        if (this.label != null) {
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, g2.getFontRenderContext());
            labelHeight = (double)(this.labelInsets.top + this.labelInsets.bottom) + labelBounds.getHeight();
        }
        double tickLabelHeight = 0.0;
        if (this.tickLabelsVisible) {
            g2.setFont(this.tickLabelFont);
            this.refreshTicks(g2, drawArea, drawArea);
            tickLabelHeight = (double)(this.tickLabelInsets.top + this.tickLabelInsets.bottom) + this.getMaxTickLabelHeight(g2, drawArea, this.verticalCategoryLabels);
        }
        return labelHeight + tickLabelHeight;
    }

    public Rectangle2D reserveAxisArea(Graphics2D g2, Plot plot, Rectangle2D drawArea, double reservedWidth) {
        if (!this.visible) {
            return new Rectangle2D.Double(drawArea.getX(), drawArea.getMaxY(), drawArea.getWidth() - reservedWidth, 0.0);
        }
        double labelHeight = 0.0;
        if (this.label != null) {
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, g2.getFontRenderContext());
            labelHeight = (double)(this.labelInsets.top + this.labelInsets.bottom) + labelBounds.getHeight();
        }
        double tickLabelHeight = 0.0;
        if (this.tickLabelsVisible) {
            g2.setFont(this.tickLabelFont);
            this.refreshTicks(g2, drawArea, drawArea);
            tickLabelHeight = (double)(this.tickLabelInsets.top + this.tickLabelInsets.bottom) + this.getMaxTickLabelHeight(g2, drawArea, this.verticalCategoryLabels);
        }
        return new Rectangle2D.Double(drawArea.getX(), drawArea.getMaxY() - labelHeight - tickLabelHeight, drawArea.getWidth() - reservedWidth, labelHeight + tickLabelHeight);
    }

    private double getMaxTickLabelHeight(Graphics2D g2, Rectangle2D drawArea, boolean vertical) {
        Font font = this.getTickLabelFont();
        g2.setFont(font);
        FontRenderContext frc = g2.getFontRenderContext();
        double maxHeight = 0.0;
        if (vertical) {
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D labelBounds = font.getStringBounds(tick.getText(), frc);
                if (!(labelBounds.getWidth() > maxHeight)) continue;
                maxHeight = labelBounds.getWidth();
            }
        } else {
            LineMetrics metrics = font.getLineMetrics("Sample", frc);
            maxHeight = metrics.getHeight() * (float)this.tickHeight - metrics.getDescent() * (float)(this.tickHeight - 1);
        }
        return maxHeight;
    }

    protected double getMaxTickLabelWidth(Graphics2D g2, Rectangle2D plotArea) {
        double maxWidth = 0.0;
        Font font = this.getTickLabelFont();
        FontRenderContext frc = g2.getFontRenderContext();
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof Tick) {
                Tick tick = (Tick)obj;
                Rectangle2D labelBounds = font.getStringBounds(tick.getText(), frc);
                if (!(labelBounds.getWidth() > maxWidth)) continue;
                maxWidth = labelBounds.getWidth();
                continue;
            }
            Tick[] ts = (Tick[])obj;
            int i = 0;
            while (i < ts.length) {
                Rectangle2D labelBounds = font.getStringBounds(ts[i].getText(), frc);
                if (labelBounds.getWidth() > maxWidth) {
                    maxWidth = labelBounds.getWidth();
                }
                ++i;
            }
        }
        return maxWidth;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof VerticalCategoryPlot;
    }

    public void configure() {
    }

    private String[] breakLine(String text, int areaWidth, FontRenderContext frc) {
        ArrayList<String> textList = new ArrayList<String>(5);
        int currWidth = areaWidth;
        AttributedString as = new AttributedString(text, this.getTickLabelFont().getAttributes());
        AttributedCharacterIterator aci = as.getIterator();
        AffineTransform affine = new AffineTransform();
        while (true) {
            LineBreakMeasurer measurer = new LineBreakMeasurer(aci, frc);
            int maxWidth = 0;
            int offset = 0;
            TextLayout layout = measurer.nextLayout(currWidth);
            while (layout != null) {
                textList.add(text.substring(offset, offset + layout.getCharacterCount()));
                int width = layout.getOutline((AffineTransform)affine).getBounds().width;
                if (maxWidth < width) {
                    maxWidth = width;
                }
                offset += layout.getCharacterCount();
                layout = measurer.nextLayout(currWidth);
            }
            if (maxWidth <= areaWidth || (currWidth -= maxWidth - currWidth) <= 0) break;
            textList.clear();
        }
        String[] texts = new String[textList.size()];
        return textList.toArray(texts);
    }
}

