/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.BarRenderer;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class HorizontalBarRenderer
extends BarRenderer
implements CategoryItemRenderer {
    public HorizontalBarRenderer() {
        this(new StandardCategoryToolTipGenerator());
    }

    public HorizontalBarRenderer(CategoryToolTipGenerator toolTipGenerator) {
        super(toolTipGenerator);
    }

    public void initialise(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, ChartRenderingInfo info) {
        super.initialise(g2, dataArea, plot, axis, data, info);
        this.calculateCategoryAndItemSpans(g2, dataArea, plot, data, dataArea.getHeight());
    }

    public void drawRangeMarker(Graphics2D g2, CategoryPlot plot, ValueAxis axis, Marker marker, Rectangle2D axisDataArea, Shape dataClipRegion) {
        double value = marker.getValue();
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        double x = axis.translateValueToJava2D(marker.getValue(), axisDataArea);
        Line2D.Double line = new Line2D.Double(x, axisDataArea.getMinY(), x, axisDataArea.getMaxY());
        g2.setPaint(marker.getOutlinePaint());
        g2.draw(line);
    }

    public void drawCategoryItem(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, int series, Object category, int categoryIndex, Object previousCategory) {
        Number dataValue = data.getValue(series, category);
        if (dataValue != null) {
            EntityCollection entities;
            double value = dataValue.doubleValue();
            double base = 0.0;
            if (this.upperClip <= 0.0) {
                if (value >= this.upperClip) {
                    return;
                }
                base = this.upperClip;
                if (value <= this.lowerClip) {
                    value = this.lowerClip;
                }
            } else if (this.lowerClip <= 0.0) {
                if (value >= this.upperClip) {
                    value = this.upperClip;
                } else if (value <= this.lowerClip) {
                    value = this.lowerClip;
                }
            } else {
                if (value <= this.lowerClip) {
                    return;
                }
                base = this.lowerClip;
                if (value >= this.upperClip) {
                    value = this.upperClip;
                }
            }
            double transX1 = axis.translateValueToJava2D(base, dataArea);
            double transX2 = axis.translateValueToJava2D(value, dataArea);
            double rectX = Math.min(transX1, transX2);
            double rectWidth = Math.abs(transX2 - transX1);
            double rectY = dataArea.getY() + dataArea.getHeight() * plot.getIntroGapPercent();
            int categories = data.getCategoryCount();
            int seriesCount = data.getSeriesCount();
            if (categories > 1) {
                rectY = rectY + (double)categoryIndex * this.categorySpan / (double)categories + (double)categoryIndex * this.categoryGapSpan / (double)(categories - 1) + (double)series * this.itemSpan / (double)(categories * seriesCount);
                if (seriesCount > 1) {
                    rectY += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
                }
            } else {
                rectY += (double)series * this.itemSpan / (double)(categories * seriesCount);
                if (seriesCount > 1) {
                    rectY += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
                }
            }
            double rectHeight = this.itemWidth;
            Rectangle2D.Double bar = new Rectangle2D.Double(rectX, rectY, rectWidth, rectHeight);
            Paint seriesPaint = plot.getSeriesPaint(series);
            g2.setPaint(seriesPaint);
            g2.fill(bar);
            if (this.itemWidth > 3.0) {
                g2.setStroke(plot.getSeriesStroke(series));
                g2.setPaint(plot.getSeriesOutlinePaint(series));
                g2.draw(bar);
                if (plot.getLabelsVisible()) {
                    Font labelFont = plot.getLabelFont();
                    g2.setFont(labelFont);
                    Paint paint = plot.getLabelPaint();
                    g2.setPaint(paint);
                    g2.drawString(String.valueOf(dataValue), (int)(rectX + rectWidth * 0.9), (int)rectY - 5);
                }
            }
            if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
                String tip = "";
                if (this.toolTipGenerator != null) {
                    tip = this.toolTipGenerator.generateToolTip(data, series, category);
                }
                CategoryItemEntity entity = new CategoryItemEntity(bar, tip, series, category, categoryIndex);
                entities.addEntity(entity);
            }
        }
    }

    public boolean hasItemGaps() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset data) {
        return data.getSeriesCount();
    }
}

