/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.HighLow;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class HighLowRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    public HighLowRenderer() {
        this(null);
    }

    public HighLowRenderer(XYToolTipGenerator tooltipGenerator) {
        super(tooltipGenerator);
    }

    public void drawItem(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset data, int series, int item, CrosshairInfo crosshairInfo) {
        Rectangle2D entityArea = null;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getEntityCollection();
        }
        HighLowDataset highLowData = (HighLowDataset)data;
        Number x = highLowData.getXValue(series, item);
        Number yHigh = highLowData.getHighValue(series, item);
        Number yLow = highLowData.getLowValue(series, item);
        Number yOpen = highLowData.getOpenValue(series, item);
        Number yClose = highLowData.getCloseValue(series, item);
        double xx = domainAxis.translateValueToJava2D(x.doubleValue(), dataArea);
        double yyHigh = rangeAxis.translateValueToJava2D(yHigh.doubleValue(), dataArea);
        double yyLow = rangeAxis.translateValueToJava2D(yLow.doubleValue(), dataArea);
        double yyOpen = rangeAxis.translateValueToJava2D(yOpen.doubleValue(), dataArea);
        double yyClose = rangeAxis.translateValueToJava2D(yClose.doubleValue(), dataArea);
        Paint p = plot.getSeriesPaint(series);
        Stroke s = plot.getSeriesStroke(series);
        HighLow hl = new HighLow(xx, yyHigh, yyLow, yyOpen, yyClose, s, p);
        Line2D l1 = hl.getOpenTickLine();
        Line2D l2 = hl.getLine();
        Line2D l3 = hl.getCloseTickLine();
        g2.setPaint(p);
        g2.setStroke(s);
        g2.draw(l1);
        g2.draw(l2);
        g2.draw(l3);
        if (entities != null) {
            if (entityArea == null) {
                entityArea = hl.getBounds();
            }
            String tip = "";
            if (this.toolTipGenerator != null) {
                tip = this.toolTipGenerator.generateToolTip(data, series, item);
            }
            XYItemEntity entity = new XYItemEntity(entityArea, tip, series, item);
            entities.addEntity(entity);
        }
    }
}

